/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.Employee;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryEscapeCharacters
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(Employee.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Employee e = new Employee();
        e.setName("Mike Dick");
        e.setEmpId(1L);
        em.persist((Object)e);
        e = new Employee();
        e.setName("Mike Jones");
        e.setEmpId(2L);
        em.persist((Object)e);
        e = new Employee();
        e.setName("Mike Smith");
        e.setEmpId(3L);
        em.persist((Object)e);
        e = new Employee();
        e.setName("M%ke Smith");
        e.setEmpId(4L);
        em.persist((Object)e);
        em.getTransaction().commit();
        em.close();
    }

    public void tearDown() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("Delete from Employee").executeUpdate();
        em.getTransaction().commit();
        em.close();
        super.tearDown();
    }

    public void testNormalQuery() {
        this.performFind("Employee.findByName", "%Dick", 1);
    }

    public void testMultiResultQuery() {
        this.performFind("Employee.findByName", "Mike%", 3);
    }

    public void testEscapedQuery() {
        this.performFind("Employee.findByNameEscaped", "M\\%%", 1);
    }

    public void testDoubleEscapedQuery() {
        this.performFind("Employee.findByName", "\\\\", 0);
    }

    public void testWrongEscape() {
        this.performFind("Employee.findByName", "M|%%", 0);
    }

    public void testDoubleSlashQuery() {
        OpenJPAEntityManagerFactorySPI ojpaEmf = this.emf;
        JDBCConfiguration conf = (JDBCConfiguration)ojpaEmf.getConfiguration();
        if (conf.getDBDictionaryInstance().requiresSearchStringEscapeForLike) {
            return;
        }
        this.performFind("Employee.findByName", "\\", 0);
    }

    public void testDifferentEscapeCharacter() {
        OpenJPAEntityManagerFactorySPI ojpaEmf = this.emf;
        JDBCConfiguration conf = (JDBCConfiguration)ojpaEmf.getConfiguration();
        conf.getDBDictionaryInstance().requiresSearchStringEscapeForLike = true;
        conf.getDBDictionaryInstance().searchStringEscape = "|";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createNamedQuery("Employee.findByName");
        q.setParameter("name", (Object)"M|%%");
        List emps = q.getResultList();
        TestQueryEscapeCharacters.assertEquals((int)1, (int)emps.size());
        String unnamedQuery = "Select e from Employee e where e.name LIKE :name";
        q = em.createQuery(unnamedQuery);
        q.setParameter("name", (Object)"M|%%");
        emps = q.getResultList();
        TestQueryEscapeCharacters.assertEquals((int)1, (int)emps.size());
        em.close();
    }

    private void performFind(String namedQuery, String parameter, int expected) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createNamedQuery(namedQuery);
        q.setParameter("name", (Object)parameter);
        List emps = q.getResultList();
        TestQueryEscapeCharacters.assertEquals((int)expected, (int)emps.size());
        String unnamedQuery = "Select e from Employee e where e.name LIKE :name";
        if (namedQuery.equals("Employee.findByNameEscaped")) {
            unnamedQuery = "Select e from Employee e where e.name LIKE :name ESCAPE '\\'";
        }
        q = em.createQuery(unnamedQuery);
        q.setParameter("name", (Object)parameter);
        emps = q.getResultList();
        TestQueryEscapeCharacters.assertEquals((int)expected, (int)emps.size());
        em.close();
    }
}

