/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Collections;
import java.util.Map;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.rop.ListResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestMethodQLQuery
extends SingleEMTestCase {
    public void setUp() {
        this.setUp(SimpleEntity.class);
    }

    OpenJPAQuery createMethodQuery(String method) {
        String methodName = ((Object)((Object)this)).getClass().getName() + "." + method;
        return this.em.createQuery("openjpa.MethodQL", methodName);
    }

    public void testMethodQLWithParameters() {
        OpenJPAQuery q = this.createMethodQuery("echo");
        Query kernelQ = (Query)q.unwrap(Query.class);
        kernelQ.declareParameters("String firstName, String lastName");
        q.setParameter("firstName", (Object)"Fred").setParameter("lastName", (Object)"Lucas");
        Object result = q.getResultList().get(0);
        TestMethodQLQuery.assertTrue((boolean)(result instanceof Map));
        Map params = (Map)result;
        TestMethodQLQuery.assertEquals((Object)"Fred", params.get("firstName"));
        TestMethodQLQuery.assertEquals((Object)"Lucas", params.get("lastName"));
    }

    public void testMethodQLWithoutParametersDeclared() {
        OpenJPAQuery q = this.createMethodQuery("echo");
        Object result = q.getResultList().get(0);
        TestMethodQLQuery.assertTrue((boolean)(result instanceof Map));
        TestMethodQLQuery.assertTrue((boolean)((Map)result).isEmpty());
    }

    public void testInvalidMethodReturnType() {
        OpenJPAQuery q = this.createMethodQuery("invalidReturnMeth");
        try {
            q.getResultList().get(0);
            TestMethodQLQuery.fail((String)"should have gotten an exception since method is invalid");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    public void testVoidMethodReturnType() {
        OpenJPAQuery q = this.createMethodQuery("voidMeth");
        try {
            q.getResultList().get(0);
            TestMethodQLQuery.fail((String)"should have gotten an exception since method is invalid");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    public static ResultObjectProvider echo(StoreContext ctx, ClassMetaData meta, boolean subs, Map params, FetchConfiguration conf) {
        return new ListResultObjectProvider(Collections.singletonList(params));
    }

    public static void voidMeth(StoreContext ctx, ClassMetaData meta, boolean subs, Map params, FetchConfiguration conf) {
    }

    public static Object invalidReturnMeth(StoreContext ctx, ClassMetaData meta, boolean subs, Map params, FetchConfiguration conf) {
        return null;
    }
}

