/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.HSQLDictionary;
import org.apache.openjpa.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.Employee;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestJDBCEscapeDate
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(Employee.class, DROP_TABLES);
    }

    public void testJDBCEscape() {
        Query q;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        Employee e = new Employee();
        e.setEmpId(1L);
        e.setName("name1");
        e.setHireDate(new Date());
        e.setHireTime(new Date());
        e.setHireTimestamp(new Date());
        em.persist((Object)e);
        tran.begin();
        em.flush();
        tran.commit();
        em.clear();
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        String[] jpql = dict instanceof SQLServerDictionary || dict instanceof HSQLDictionary ? new String[]{"select a from Employee a where a.hireDate >= {d '2009-08-25'}", "select a from Employee a where a.hireDate >= {d '2009-08-05'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.1'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.12'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.123'}", "select {t '00:00:00'}, a.empId from Employee a"} : new String[]{"select a from Employee a where a.hireDate >= {d '2009-08-25'}", "select a from Employee a where a.hireDate >= {d '2009-8-5'}", "select a from Employee a where a.hireTime >= {t '00:00:00'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.1'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.12'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.123'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.1234'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.12345'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.123456'}", "select {t '00:00:00'}, a.empId from Employee a"};
        for (int i = 0; i < jpql.length; ++i) {
            Query q2 = em.createQuery(jpql[i]);
            List results = q2.getResultList();
            Assert.assertEquals((String)("For jpql[" + i + "]"), (int)1, (int)results.size());
        }
        String[] havingJpql = new String[]{"select a from Employee a group by a.hireTime having a.hireTime >= {t '00:00:00'}", "select a from Employee a group by a.hireDate having a.hireDate >= {d '2009-08-25'}", "select a from Employee a group by a.hireTimestamp having a.hireTimestamp >= {d '2009-08-25'}"};
        for (int j = 0; j < havingJpql.length; ++j) {
            q = em.createQuery(havingJpql[j]);
            List results = q.getResultList();
            Assert.assertEquals((String)("For havingJpql[" + j + "]"), (int)1, (int)results.size());
        }
        em.getTransaction().begin();
        String update = dict instanceof SQLServerDictionary || dict instanceof HSQLDictionary ? "update Employee a set a.hireTimestamp = {ts '2009-08-25 00:00:00.123'} where a.empId = 1" : "update Employee a set a.hireTimestamp = {ts '2009-08-25 00:00:00.123456'} where a.empId = 1";
        q = em.createQuery(update);
        int updateCnt = q.executeUpdate();
        em.getTransaction().commit();
        Assert.assertEquals((int)1, (int)updateCnt);
        em.close();
    }
}

