/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import javax.persistence.FlushModeType;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestInMemoryQueryMatchEscapes
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(AllFieldTypes.class);
    }

    public void testDatabaseEscape() {
        OpenJPAQuery q = this.escapeHelper(false);
        q.setFlushMode(FlushModeType.AUTO);
        q.getEntityManager().flush();
        AllFieldTypes aft = (AllFieldTypes)q.getSingleResult();
        TestInMemoryQueryMatchEscapes.assertEquals((String)"foo_bar", (String)aft.getStringField());
        q.getEntityManager().getTransaction().rollback();
    }

    public void testInMemoryEscape() {
        OpenJPAQuery q = this.escapeHelper(true);
        q.setFlushMode(FlushModeType.COMMIT);
        try {
            q.getSingleResult();
            TestInMemoryQueryMatchEscapes.fail((String)"OpenJPA doesn't support escape syntax for in-mem queries");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private OpenJPAQuery escapeHelper(boolean inMem) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AllFieldTypes aft = new AllFieldTypes();
        aft.setStringField("foo_bar");
        em.persist((Object)aft);
        aft = new AllFieldTypes();
        aft.setStringField("foozbar");
        em.persist((Object)aft);
        return (OpenJPAQuery)em.createQuery("select e from AllFieldTypes e where e.stringField like 'foox_bar' escape 'x'");
    }
}

