/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.query.SimpleEntity2;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDupNamedQuery
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(SimpleEntity.class, SimpleEntity2.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new SimpleEntity("Name One", "Value One"));
        em.persist((Object)new SimpleEntity("Name Two", "Value Two"));
        em.persist((Object)new SimpleEntity2("Name2 One", "Value2 One"));
        em.persist((Object)new SimpleEntity2("Name2 Two", "Value2 Two"));
        em.getTransaction().commit();
        em.close();
    }

    public void testSimpleQuery() {
        this.simpleQuery(false, "FindOne", "FindAll", "Name One", "Value One", "Name Two", "Value Two");
        this.simpleQuery(true, "Find2One", "Find2All", "Name2 One", "Value2 One", "Name2 Two", "Value2 Two");
        this.simpleQuery(false, "FindXTwo", null, "Name Two", "Value Two", null, null);
    }

    private void simpleQuery(boolean simple2, String findOneQName, String findAllQName, String nameOne, String ValueOne, String nameTwo, String ValueTwo) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List list = em.createNamedQuery(findOneQName).setParameter(1, (Object)nameOne).getResultList();
        TestDupNamedQuery.assertNotNull((Object)list);
        TestDupNamedQuery.assertEquals((int)list.size(), (int)1);
        Object o2 = list.get(0);
        TestDupNamedQuery.assertTrue((boolean)(simple2 ? o2 instanceof SimpleEntity2 : o2 instanceof SimpleEntity));
        TestDupNamedQuery.assertEquals((String)(simple2 ? ((SimpleEntity2)o2).getValue() : ((SimpleEntity)o2).getValue()), (String)ValueOne);
        if (findAllQName != null) {
            list = em.createNamedQuery(findAllQName).getResultList();
            TestDupNamedQuery.assertNotNull((Object)list);
            TestDupNamedQuery.assertEquals((int)list.size(), (int)2);
            for (Object o2 : list) {
                TestDupNamedQuery.assertTrue((boolean)(simple2 ? o2 instanceof SimpleEntity2 : o2 instanceof SimpleEntity));
                String n = null;
                String v = null;
                if (simple2) {
                    n = ((SimpleEntity2)o2).getName();
                    v = ((SimpleEntity2)o2).getValue();
                } else {
                    n = ((SimpleEntity)o2).getName();
                    v = ((SimpleEntity)o2).getValue();
                }
                if (n.equals(nameOne)) {
                    TestDupNamedQuery.assertTrue((boolean)v.equals(ValueOne));
                    continue;
                }
                if (n.equals(nameTwo)) {
                    TestDupNamedQuery.assertTrue((boolean)v.equals(ValueTwo));
                    continue;
                }
                TestDupNamedQuery.assertTrue((boolean)false);
            }
        }
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestDupNamedQuery.class);
    }
}

