/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.persistence.query.BaseQueryTest;
import org.apache.openjpa.persistence.query.common.apps.ComplexA;
import org.apache.openjpa.persistence.query.common.apps.ComplexB;
import org.apache.openjpa.persistence.query.common.apps.ComplexC;
import org.apache.openjpa.persistence.query.common.apps.ComplexD;
import org.apache.openjpa.persistence.query.common.apps.ComplexE;
import org.apache.openjpa.persistence.query.common.apps.ComplexF;
import org.apache.openjpa.persistence.query.common.apps.ComplexG;

public class TestComplexQueries
extends BaseQueryTest {
    public TestComplexQueries(String test) {
        super(test);
    }

    public void setUp() {
        this.clear();
    }

    public void clear() {
        this.deleteAll(ComplexA.class);
        this.deleteAll(ComplexB.class);
        this.deleteAll(ComplexC.class);
        this.deleteAll(ComplexD.class);
        this.deleteAll(ComplexE.class);
        this.deleteAll(ComplexF.class);
        this.deleteAll(ComplexG.class);
    }

    public void complexQuery(int size, Object ob, String filter, Class c) {
        Broker broker = this.getBrokerFactory().newBroker();
        broker.setIgnoreChanges(false);
        broker.begin();
        broker.persist(ob, null);
        broker.commit();
        broker.begin();
        String qstrng = "SELECT o FROM " + c.getSimpleName() + " o WHERE o." + filter;
        this.assertSize(size, (List)broker.newQuery("javax.persistence.JPQL", c, (Object)qstrng).execute());
        broker.commit();
        broker.close();
        broker = this.getBrokerFactory().newBroker();
        broker.begin();
        this.assertSize(size, (List)broker.newQuery("javax.persistence.JPQL", c, (Object)qstrng).execute());
        broker.rollback();
        broker.close();
    }

    public void testComplex1() {
        this.complexQuery(1, new ComplexA("test", 0, null, null), "stringA = 'test'", ComplexA.class);
    }

    public void testComplex2() {
        this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "stringG = 'testg'", ComplexG.class);
    }

    public void testComplex3() {
        this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.e.d.c.b.a.stringA = 'testa'", ComplexG.class);
    }

    public void testComplex4() {
        this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.e.d.c.b.a.stringA = 'testa' AND o.f.e.d.c.b.stringB = 'testb'", ComplexG.class);
    }

    public void testComplex5() {
        this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.e.d.c.b.a.stringA = 'testa' AND o.f.e.d.c.b.stringB = 'testb' AND o.f.e.d.c.stringC = 'testc'", ComplexG.class);
    }

    public void testComplex6() {
        this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.e.d.c.b.a.stringA = 'testa' AND o.f.e.d.c.b.stringB = 'testb' AND o.f.e.d.c.stringC = 'testc' AND o.f.e.d.stringD = 'testd'", ComplexG.class);
    }

    public void testComplex7() {
        this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.e.d.c.b.a.stringA = 'testa' AND o.f.e.d.c.b.stringB = 'testb' AND o.f.e.d.c.stringC = 'testc' AND o.f.e.d.stringD = 'testd' AND o.f.e.stringE = 'teste'", ComplexG.class);
    }

    public void testComplex8() {
        this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.e.d.c.b.a.stringA = 'testa' AND o.f.e.d.c.b.stringB = 'testb' AND o.f.e.d.c.stringC = 'testc' AND o.f.e.d.stringD = 'testd' AND o.f.e.stringE = 'teste' AND o.f.stringF = 'testf'", ComplexG.class);
    }

    public void testComplex9() {
        this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.e.d.c.b.a.stringA = 'testa' AND o.f.e.d.c.b.stringB = 'testb' AND o.f.e.d.c.stringC = 'testc' AND o.f.e.d.stringD = 'testd' AND o.f.e.stringE = 'teste' AND o.f.stringF = 'testf' AND o.f.e.d.intD < 1 AND o.f.e.d.intD > -1", ComplexG.class);
    }

    public void testComplex10() {
        this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.stringF = 'testf'", ComplexG.class);
    }

    public void testComplex11() {
        this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.stringF = 'testf' AND o.stringG = 'testg'", ComplexG.class);
    }

    public void testComplex12() {
        try {
            this.complexQuery(1, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.stringF = 'testf'OR o.stringG = 'testg'", ComplexG.class);
        }
        catch (AssertionFailedError afe) {
            this.bug(449, afe, "ORs and relational queries");
        }
    }

    public void testComplex13() {
        this.complexQuery(0, new ComplexG("testg", 0, null, new ComplexF("testf", 0, null, null, new ComplexE("teste", 0, null, null, new ComplexD("testd", 0, null, null, new ComplexC("testc", 0, null, null, new ComplexB("testb", 0, null, null, new ComplexA("testa", 0, null, null))))))), "f.stringF = 'testfXXX'", ComplexG.class);
    }
}

