/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Version;
import org.apache.openjpa.persistence.query.Customer;
import org.apache.openjpa.persistence.query.OrderItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="TODR")
public class Order {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    int oid;
    double amount;
    boolean delivered;
    @ManyToOne(fetch=FetchType.EAGER)
    Customer customer;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="order")
    Collection<OrderItem> lineitems = new ArrayList<OrderItem>();
    @Version
    long version;
    Timestamp orderTs;

    public Order() {
    }

    public Order(double amt, boolean delivered, Customer c) {
        this.amount = amt;
        this.delivered = delivered;
        this.customer = c;
        if (c != null) {
            c.getOrders().add(this);
        }
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public boolean isDelivered() {
        return this.delivered;
    }

    public void setDelivered(boolean delivered) {
        this.delivered = delivered;
    }

    public int getOid() {
        return this.oid;
    }

    public String toString() {
        return "Order:" + this.oid + " amount:" + this.amount + " delivered:" + this.delivered + " customer:" + (this.customer != null ? this.customer.getCid() : Integer.valueOf(-1));
    }

    public Collection<OrderItem> getLineitems() {
        return this.lineitems;
    }

    public void setLineitems(Collection<OrderItem> lineitems) {
        this.lineitems = lineitems;
    }

    public Timestamp getOrderTs() {
        return this.orderTs;
    }

    public void setOrderTs(Timestamp orderTs) {
        this.orderTs = orderTs;
    }
}

