/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Version;
import org.apache.openjpa.persistence.query.Account;
import org.apache.openjpa.persistence.query.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="TCUS")
public class Customer {
    @EmbeddedId
    CustomerKey cid;
    @Column(length=30)
    @Basic
    String name;
    @Enumerated(value=EnumType.STRING)
    @Basic
    CreditRating creditRating;
    @Version
    long version;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="customer")
    private Collection<Order> orders = new ArrayList<Order>();
    @OneToMany(mappedBy="cust")
    private List<Account> accounts = new ArrayList<Account>();

    public Customer() {
    }

    public Customer(CustomerKey cid, String name, CreditRating rating) {
        this.cid = cid;
        this.name = name;
        this.creditRating = rating;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreditRating getRating() {
        return this.creditRating;
    }

    public void setRating(CreditRating rating) {
        this.creditRating = rating;
    }

    public Collection<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(Collection<Order> orders) {
        this.orders = orders;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public String toString() {
        return "Customer:" + this.cid + " name:" + this.name;
    }

    public CustomerKey getCid() {
        return this.cid;
    }

    public void setCid(CustomerKey cid) {
        this.cid = cid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CreditRating {
        POOR,
        GOOD,
        EXCELLENT;

    }

    @Embeddable
    public static class CustomerKey
    implements Serializable {
        public String cyCode;
        public int id;

        public CustomerKey() {
        }

        public CustomerKey(String cc, int id) {
            this.cyCode = cc;
            this.id = id;
        }

        public String toString() {
            return this.cyCode + "/" + this.id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CustomerKey)) {
                return false;
            }
            CustomerKey key = (CustomerKey)obj;
            return key.cyCode.equals(this.cyCode) && key.id == this.id;
        }

        public int hashCode() {
            return this.cyCode.hashCode() ^ this.id;
        }
    }
}

