/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy.entities;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.apache.openjpa.persistence.proxy.entities.Annuity;
import org.apache.openjpa.persistence.proxy.entities.AnnuityPersistebleObject;
import org.apache.openjpa.persistence.proxy.entities.IAnnuity;
import org.apache.openjpa.persistence.proxy.entities.IPayout;

@Entity
@AttributeOverride(name="lastUpdateDate", column=@Column(name="LAST_UPDATE_TS"))
public class Payout
extends AnnuityPersistebleObject
implements IPayout {
    private static final long serialVersionUID = 2837981324963617180L;
    private BigDecimal taxableAmount;
    private Calendar startDate;
    private Calendar endDate;
    private IAnnuity annuity;

    @Column(name="TAXABLE_AMOUNT")
    public BigDecimal getTaxableAmount() {
        return this.taxableAmount;
    }

    public void setTaxableAmount(BigDecimal payoutTaxableAmt) {
        this.taxableAmount = payoutTaxableAmt;
        if (payoutTaxableAmt != null) {
            DecimalFormat df = new DecimalFormat("#.##");
            this.taxableAmount = new BigDecimal(df.format(payoutTaxableAmt));
        }
    }

    @Column(name="START_DATE")
    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    @Column(name="END_DATE")
    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar payoutEndDate) {
        this.endDate = payoutEndDate;
    }

    @ManyToOne(targetEntity=Annuity.class, fetch=FetchType.EAGER)
    @JoinColumn(name="FK_ANNUITY_ID")
    public IAnnuity getAnnuity() {
        return this.annuity;
    }

    public void setAnnuity(IAnnuity annuity) {
        this.annuity = annuity;
    }
}

