/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy.entities;

import java.text.DecimalFormat;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.apache.openjpa.persistence.proxy.entities.Annuity;
import org.apache.openjpa.persistence.proxy.entities.IEquityAnnuity;

@Entity
@DiscriminatorValue(value="EQUITY")
public class EquityAnnuity
extends Annuity
implements IEquityAnnuity {
    private static final long serialVersionUID = -7227462924769151013L;
    private String fundNames;
    private Double indexRate;

    @Column(name="FUND_NAMES")
    public String getFundNames() {
        return this.fundNames;
    }

    public void setFundNames(String fundNames) {
        this.fundNames = fundNames;
    }

    @Column(name="INDEX_RATE")
    public Double getIndexRate() {
        return this.indexRate;
    }

    public void setIndexRate(Double indexRate) {
        this.indexRate = indexRate;
        if (this.indexRate != null) {
            DecimalFormat df = new DecimalFormat("#.##");
            this.indexRate = new Double(df.format(indexRate));
        }
    }
}

