/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy.entities;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.apache.openjpa.persistence.proxy.entities.AnnuityPersistebleObject;
import org.apache.openjpa.persistence.proxy.entities.IAnnuity;
import org.apache.openjpa.persistence.proxy.entities.IPayor;
import org.apache.openjpa.persistence.proxy.entities.IPayout;
import org.apache.openjpa.persistence.proxy.entities.IRider;
import org.apache.openjpa.persistence.proxy.entities.Payor;
import org.apache.openjpa.persistence.proxy.entities.Payout;
import org.apache.openjpa.persistence.proxy.entities.Rider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="DTYPE", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="ANNUITY")
@AttributeOverride(name="lastUpdateDate", column=@Column(name="LAST_UPDATE_TS"))
public class Annuity
extends AnnuityPersistebleObject
implements IAnnuity {
    private Double lastPaidAmt;
    private String AccountNumber;
    private Double amount;
    private String annuityHolderId;
    private List<IPayout> payouts = new ArrayList<IPayout>();
    private List<IRider> riders = new ArrayList<IRider>();
    private List<IPayor> payors = new ArrayList<IPayor>();

    @Override
    @Column(name="LAST_PAID_AMT")
    public Double getLastPaidAmt() {
        return this.lastPaidAmt;
    }

    @Override
    public void setLastPaidAmt(Double lastPaidAmt) {
        this.lastPaidAmt = lastPaidAmt;
        if (this.lastPaidAmt != null) {
            DecimalFormat df = new DecimalFormat("#.##");
            this.lastPaidAmt = new Double(df.format(lastPaidAmt));
        }
    }

    @Override
    @Column(name="ACCOUNT_NUMBER")
    public String getAccountNumber() {
        return this.AccountNumber;
    }

    @Override
    public void setAccountNumber(String accountNumber) {
        this.AccountNumber = accountNumber;
    }

    @Override
    @Column(name="AMOUNT")
    public Double getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(Double amount) {
        this.amount = amount;
        if (this.amount != null) {
            DecimalFormat df = new DecimalFormat("#.##");
            this.amount = new Double(df.format(amount));
        }
    }

    @Override
    @Column(name="FK_ANNUITY_HOLDER_ID")
    public String getAnnuityHolderId() {
        return this.annuityHolderId;
    }

    @Override
    public void setAnnuityHolderId(String annuityHolderId) {
        this.annuityHolderId = annuityHolderId;
    }

    @Override
    @ManyToMany(targetEntity=Payor.class, fetch=FetchType.EAGER)
    @JoinTable(name="ANNUITY_PAYOR", joinColumns={@JoinColumn(name="FK_ANNUITY_ID")}, inverseJoinColumns={@JoinColumn(name="FK_PAYOR_ID")})
    public List<IPayor> getPayors() {
        return this.payors;
    }

    @Override
    public void setPayors(List<IPayor> payors) {
        this.payors = payors;
    }

    @Override
    @OneToMany(targetEntity=Payout.class, mappedBy="annuity", fetch=FetchType.EAGER)
    public List<IPayout> getPayouts() {
        return this.payouts;
    }

    @Override
    public void setPayouts(List<IPayout> payouts) {
        this.payouts = payouts;
    }

    @Override
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=Rider.class, fetch=FetchType.EAGER)
    @JoinTable(name="ANNUITY_RIDER", joinColumns={@JoinColumn(name="FK_ANNUITY_ID")}, inverseJoinColumns={@JoinColumn(name="FK_RIDER_ID")})
    public List<IRider> getRiders() {
        return this.riders;
    }

    @Override
    public void setRiders(List<IRider> riders) {
        this.riders = riders;
    }
}

