/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Version;
import org.apache.openjpa.persistence.DetachedState;
import org.apache.openjpa.persistence.ElementDependent;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumn;
import org.apache.openjpa.persistence.jdbc.OrderColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DetachedState
public class TreeNode
implements Serializable {
    @Id
    @GeneratedValue
    private long id;
    private String name;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @ElementJoinColumn(name="ParentID")
    @OrderColumn(name="Sequence")
    @ElementDependent
    private List<TreeNode> childern = new ArrayList<TreeNode>();
    @Version
    private int version;

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addNode(TreeNode node) {
        this.addNode(node, this.childern.size());
    }

    public void addNode(TreeNode node, int position) {
        this.checkSequenceRange(position);
        this.childern.add(position, node);
    }

    public boolean removeNode(TreeNode node) {
        return this.childern.remove(node);
    }

    public TreeNode removeNode(int sequence) {
        this.checkSequenceRange(sequence);
        return this.childern.remove(sequence);
    }

    public TreeNode getNode(int sequence) {
        this.checkSequenceRange(sequence);
        return this.childern.get(sequence);
    }

    public List<TreeNode> getNodes() {
        return this.childern;
    }

    public void clearNodes() {
        this.childern.clear();
    }

    public boolean isLeaf() {
        return this.childern.isEmpty();
    }

    protected void checkSequenceRange(int sequence) throws IllegalArgumentException {
        int size = this.childern.size();
        if (sequence < 0 || sequence > size) {
            throw new IllegalArgumentException("Sequence number is beyond range of 0 to " + size + ".");
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void createTree(int[] fanOuts) {
        if (fanOuts.length == 0) {
            return;
        }
        int[] nextFanOuts = new int[fanOuts.length];
        System.arraycopy(fanOuts, 1, nextFanOuts, 0, fanOuts.length - 1);
        for (int j = 0; j < fanOuts[0]; ++j) {
            TreeNode child = new TreeNode();
            child.setName(this.getName() + "." + j);
            this.addNode(child);
            child.createTree(nextFanOuts);
        }
    }

    public void modify(int[] fanOuts) {
        int i;
        if (fanOuts == null || fanOuts.length == 0) {
            return;
        }
        int n = fanOuts[0];
        int[] nextFanOuts = new int[fanOuts.length];
        System.arraycopy(fanOuts, 1, nextFanOuts, 0, fanOuts.length - 1);
        List<TreeNode> children = this.getNodes();
        int diff = children.size() - n;
        if (diff < 0) {
            for (i = 0; i < -diff; ++i) {
                TreeNode newChild = new TreeNode();
                int position = this.getNodes().size();
                newChild.setName(this.getName() + "." + position);
                this.addNode(newChild);
            }
        } else if (diff > 0) {
            for (i = 0; i < diff; ++i) {
                int position = this.getNodes().size() - 1;
                this.removeNode(position);
            }
        }
        children = this.getNodes();
        for (TreeNode child : children) {
            child.modify(nextFanOuts);
        }
    }

    public int[] getFanOuts() {
        return this.getFanOuts(new int[0]);
    }

    private int[] getFanOuts(int[] list) {
        List<TreeNode> children = this.getNodes();
        if (children.isEmpty()) {
            return list;
        }
        int[] fanOuts = new int[children.size()];
        int i = 0;
        for (TreeNode child : children) {
            fanOuts[i++] = child.getNodes().size();
        }
        for (int j = 0; j < fanOuts.length - 1; ++j) {
            if (fanOuts[j] == fanOuts[j + 1]) continue;
            throw new RuntimeException("non-uniform fanouts for children  of " + this.getName());
        }
        int[] newList = new int[list.length + 1];
        System.arraycopy(list, 0, newList, 0, list.length);
        newList[list.length] = children.size();
        return children.get(0).getFanOuts(newList);
    }

    public void print(PrintStream out) {
        this.print(2, out);
    }

    private void print(int tab, PrintStream out) {
        for (int i = 0; i < tab; ++i) {
            out.print(" ");
        }
        out.println(this.getName());
        for (TreeNode child : this.getNodes()) {
            child.print(tab + 2, out);
        }
    }
}

