/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.nullity;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.AbstractDB2Dictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.nullity.AbstractNullityTestCase;
import org.apache.openjpa.persistence.nullity.TimestampedEntity;

public class TestReadOnlyNullity
extends AbstractNullityTestCase {
    private boolean skip = false;

    public void setUp() {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(new Object[0]);
        if (((JDBCConfiguration)emf.getConfiguration()).getDBDictionaryInstance() instanceof AbstractDB2Dictionary) {
            this.setUp(CLEAR_TABLES, TimestampedEntity.class);
        } else {
            this.skip = true;
        }
    }

    public void testNonInsertableBlobDoesNotFail() {
        if (!this.skip) {
            TimestampedEntity pc = new TimestampedEntity();
            pc.setNonInsertableNonNullableDate(null);
            this.assertCommitSucceeds(pc, NEW);
        }
    }

    public void testNonUpdatableBlobDoesNotFail() {
        if (!this.skip) {
            TimestampedEntity pc = new TimestampedEntity();
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)pc);
            em.getTransaction().commit();
            em.clear();
            pc.setNonUpdatableNonNullableDate(null);
            this.assertCommitSucceeds(pc, !NEW);
        }
    }
}

