/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.nullity;

import javax.persistence.RollbackException;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.nullity.AbstractNullityTestCase;
import org.apache.openjpa.persistence.nullity.NullValues;

public class TestBasicFieldNullity
extends AbstractNullityTestCase {
    public void setUp() {
        this.setUp(CLEAR_TABLES, NullValues.class);
    }

    public void testNullOnOptionalFieldIsAllowed() {
        NullValues pc = new NullValues();
        pc.setOptional(null);
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnNonOptionalFieldIsDisallowed() {
        NullValues pc = new NullValues();
        pc.setNotOptional(null);
        this.assertCommitFails(pc, NEW, InvalidStateException.class);
    }

    public void testNotNullOnOptionalFieldIsAllowed() {
        NullValues pc = new NullValues();
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNotNullOnNonOptionalFieldIsAllowed() {
        NullValues pc = new NullValues();
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnNullableColumnAllowed() {
        NullValues pc = new NullValues();
        pc.setNullable(null);
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnNonNullableColumnIsDisallowed() {
        NullValues pc = new NullValues();
        pc.setNotNullable(null);
        this.assertCommitFails(pc, NEW, RollbackException.class);
    }

    public void testNotNullOnNullableColumnIsAllowed() {
        NullValues pc = new NullValues();
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNotNullOnNonNullableColumnIsAllowed() {
        NullValues pc = new NullValues();
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnOptionalBlobFieldIsAllowed() {
        NullValues pc = new NullValues();
        pc.setOptionalBlob(null);
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnNonOptionalBlobFieldIsDisallowed() {
        NullValues pc = new NullValues();
        pc.setNotOptionalBlob(null);
        this.assertCommitFails(pc, NEW, InvalidStateException.class);
    }

    public void testNullOnNullableBlobColumnAllowed() {
        NullValues pc = new NullValues();
        pc.setNullableBlob(null);
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnNonNullableBlobColumnIsDisallowed() {
        NullValues pc = new NullValues();
        pc.setNotNullableBlob(null);
        this.assertCommitFails(pc, NEW, RollbackException.class);
    }

    public void testX() {
        NullValues pc = new NullValues();
        this.assertCommitSucceeds(pc, NEW);
        OpenJPAPersistence.getEntityManager((Object)pc).close();
        pc.setNotNullableBlob(null);
        this.assertCommitFails(pc, !NEW, RollbackException.class);
    }
}

