/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.models.library;

import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.openjpa.persistence.models.library.Borrower;

@Entity
@Table(name="LIBVOLUNTEER")
public class Volunteer {
    @Id
    @GeneratedValue
    private int oid;
    @Basic
    private int hours_per_week;
    @OneToOne(optional=false)
    private Borrower borrower;

    protected Volunteer() {
    }

    public Volunteer(Borrower borrower) {
        if (borrower == null) {
            throw new IllegalArgumentException("borrower cannot be null");
        }
        if (borrower.getVolunteer() != null) {
            throw new IllegalArgumentException("borrower is already a volunteer");
        }
        this.borrower = borrower;
        borrower.setVolunteer(this);
    }

    public Borrower getBorrower() {
        return this.borrower;
    }

    public int getHoursPerWeek() {
        return this.hours_per_week;
    }

    public void setHoursPerWeek(int hours) {
        if (hours < 0) {
            throw new IllegalArgumentException("hours must be >= 0");
        }
        this.hours_per_week = hours;
    }

    public String toString() {
        return "volunteer [" + this.oid + "] \"" + this.borrower.getName() + "\"";
    }

    public int hashCode() {
        return this.oid;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.oid == 0) {
            return false;
        }
        if (other instanceof Volunteer) {
            Volunteer ov = (Volunteer)other;
            return this.oid == ov.oid;
        }
        return false;
    }
}

