/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.models.library;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.apache.openjpa.persistence.models.library.Book;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="LIBSUBJECT")
public class Subject {
    @Id
    @GeneratedValue
    private int oid;
    @Basic
    private String name;
    @ManyToMany
    private Set<Book> books;

    protected Subject() {
    }

    public Subject(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() <= 0) {
            throw new IllegalArgumentException("name cannot be empty or null");
        }
        this.name = name;
        this.books = new HashSet<Book>();
    }

    public String getName() {
        return this.name;
    }

    public List<Book> getBooks() {
        return new ArrayList<Book>(this.books);
    }

    boolean addBook(Book book) {
        if (book != null) {
            return this.books.add(book);
        }
        return false;
    }

    boolean removeBook(Book book) {
        if (book != null) {
            return this.books.remove(book);
        }
        return false;
    }

    public String toString() {
        return "category [" + this.oid + "] \"" + this.name + "\"";
    }

    public int hashCode() {
        return this.oid;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.oid == 0) {
            return false;
        }
        if (other instanceof Subject) {
            Subject oc = (Subject)other;
            return this.oid == oc.oid;
        }
        return false;
    }
}

