/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.models.library;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.openjpa.persistence.models.library.Book;
import org.apache.openjpa.persistence.models.library.Volunteer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="LIBBORROWER")
public class Borrower {
    @Id
    @GeneratedValue
    private int oid;
    @Basic
    private String name;
    @OneToMany(mappedBy="borrower", fetch=FetchType.EAGER)
    private Set<Book> books;
    @OneToOne(mappedBy="borrower", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    private Volunteer volunteer;

    protected Borrower() {
    }

    public Borrower(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() <= 0) {
            throw new IllegalArgumentException("name cannot be empty or null");
        }
        this.name = name;
        this.books = new HashSet<Book>();
    }

    public String getName() {
        return this.name;
    }

    public List<Book> getBooks() {
        if (this.books == null) {
            return null;
        }
        return new ArrayList<Book>(this.books);
    }

    public void borrowBook(Book book) {
        if (book == null) {
            return;
        }
        this.books.add(book);
        book.setBorrower(this);
    }

    public void returnBook(Book book) {
        if (book == null) {
            return;
        }
        this.books.remove(book);
        book.clearBorrower();
    }

    void setVolunteer(Volunteer volunteer) {
        this.volunteer = volunteer;
    }

    public Volunteer getVolunteer() {
        return this.volunteer;
    }

    public String toString() {
        return "borrower [" + this.oid + "] " + this.name;
    }

    public int hashCode() {
        return this.oid;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.oid == 0) {
            return false;
        }
        if (other instanceof Borrower) {
            Borrower ob = (Borrower)other;
            return this.oid == ob.oid;
        }
        return false;
    }
}

