/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.models.library;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.openjpa.persistence.models.library.Borrower;
import org.apache.openjpa.persistence.models.library.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="LIBBOOK")
public class Book {
    private static final int WEEKS_TIME_MS = 604800000;
    @Id
    @GeneratedValue
    private int oid;
    @Basic
    private String title;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dueDate;
    @ManyToOne
    private Borrower borrower;
    @ManyToMany(mappedBy="books", cascade={CascadeType.PERSIST})
    private Set<Subject> subjects;

    protected Book() {
    }

    public Book(String title) {
        if (title != null) {
            title = title.trim();
        }
        if (title == null || title.length() <= 0) {
            throw new IllegalArgumentException("Title cannot be empty or null");
        }
        this.title = title;
        this.subjects = new HashSet<Subject>();
    }

    public String getTitle() {
        return this.title;
    }

    public Borrower getBorrower() {
        return this.borrower;
    }

    void setBorrower(Borrower borrower) {
        if (borrower != null) {
            this.borrower = borrower;
            long one_week_out = System.currentTimeMillis() + 604800000L;
            this.dueDate = new Date(one_week_out);
        }
    }

    void clearBorrower() {
        this.borrower = null;
        this.dueDate = null;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public boolean addSubject(Subject subject) {
        boolean retv = false;
        if (subject != null && subject.addBook(this)) {
            retv = true;
            this.subjects.add(subject);
        }
        return retv;
    }

    public boolean removeSubject(Subject subject) {
        boolean retv = false;
        if (subject != null && subject.removeBook(this)) {
            retv = true;
            this.subjects.remove(subject);
        }
        return retv;
    }

    public List<Subject> getSubjects() {
        if (this.subjects == null) {
            return null;
        }
        return new ArrayList<Subject>(this.subjects);
    }

    public String toString() {
        return "book [" + this.oid + "] \"" + this.title + "\"" + (this.dueDate == null ? "" : " due back: " + this.dueDate);
    }

    public int hashCode() {
        return this.oid;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.oid == 0) {
            return false;
        }
        if (other instanceof Book) {
            Book ob = (Book)other;
            return this.oid == ob.oid;
        }
        return false;
    }
}

