/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.meta.common.apps.ValueStrategyPC;
import org.apache.openjpa.util.OpenJPAException;

public class TestValueStrategies
extends AbstractTestCase {
    public TestValueStrategies(String test) {
        super(test, "metacactusapp");
    }

    public void setUp() {
        this.deleteAll(ValueStrategyPC.class);
    }

    public void testIgnoreUpdate() {
        ValueStrategyPC pc = new ValueStrategyPC();
        pc.setName("pc");
        pc.setIgnoreUpdate(10);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        TestValueStrategies.assertEquals((int)10, (int)pc.getIgnoreUpdate());
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid);
        TestValueStrategies.assertNotNull((Object)pc);
        TestValueStrategies.assertEquals((int)10, (int)pc.getIgnoreUpdate());
        this.startTx((EntityManager)pm);
        pc.setIgnoreUpdate(100);
        TestValueStrategies.assertFalse((boolean)pm.isDirty((Object)pc));
        pm.transactional((Object)pc, false);
        this.endTx((EntityManager)pm);
        TestValueStrategies.assertEquals((int)10, (int)pc.getIgnoreUpdate());
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid);
        TestValueStrategies.assertNotNull((Object)pc);
        TestValueStrategies.assertEquals((int)10, (int)pc.getIgnoreUpdate());
        this.endEm((EntityManager)pm);
    }

    public void testRestrictUpdate() {
        ValueStrategyPC pc = new ValueStrategyPC();
        pc.setName("pc");
        pc.setRestrictUpdate(10);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        TestValueStrategies.assertEquals((int)10, (int)pc.getRestrictUpdate());
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid);
        TestValueStrategies.assertNotNull((Object)pc);
        TestValueStrategies.assertEquals((int)10, (int)pc.getRestrictUpdate());
        this.startTx((EntityManager)pm);
        try {
            pc.setRestrictUpdate(100);
            TestValueStrategies.fail((String)"Allowed update of restricted field.");
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        this.endTx((EntityManager)pm);
        TestValueStrategies.assertEquals((int)10, (int)pc.getRestrictUpdate());
        this.endEm((EntityManager)pm);
    }

    public void testUUID() {
        ValueStrategyPC pc = new ValueStrategyPC();
        ValueStrategyPC pc2 = new ValueStrategyPC();
        pc.setName("pc");
        pc2.setName("pc2");
        TestValueStrategies.assertNull((Object)pc.getUUID());
        TestValueStrategies.assertNull((Object)pc2.getUUID());
        TestValueStrategies.assertNull((Object)pc.getUUIDHex());
        TestValueStrategies.assertNull((Object)pc2.getUUIDHex());
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.setOptimistic(true);
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        pm.persist((Object)pc2);
        String str = pc.getUUID();
        String hex = pc.getUUIDHex();
        TestValueStrategies.assertTrue((!pm.isStoreActive() ? 1 : 0) != 0);
        this.endTx((EntityManager)pm);
        String str2 = pc2.getUUID();
        String hex2 = pc2.getUUIDHex();
        Object oid = pm.getObjectId((Object)pc);
        Object oid2 = pm.getObjectId((Object)pc2);
        this.endEm((EntityManager)pm);
        TestValueStrategies.assertNotNull((Object)str);
        TestValueStrategies.assertNotNull((Object)str2);
        TestValueStrategies.assertTrue((!str.equals(str2) ? 1 : 0) != 0);
        TestValueStrategies.assertNotNull((Object)hex);
        TestValueStrategies.assertNotNull((Object)hex2);
        TestValueStrategies.assertTrue((!hex.equals(hex2) ? 1 : 0) != 0);
        pm = this.currentEntityManager();
        pc = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid);
        pc2 = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid2);
        TestValueStrategies.assertEquals((String)str, (String)pc.getUUID());
        TestValueStrategies.assertEquals((String)str2, (String)pc2.getUUID());
        TestValueStrategies.assertEquals((String)hex, (String)pc.getUUIDHex());
        TestValueStrategies.assertEquals((String)hex2, (String)pc2.getUUIDHex());
        this.startTx((EntityManager)pm);
        pc.setUUIDHex("foo");
        pc2.setUUIDHex("bar");
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid);
        pc2 = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid2);
        TestValueStrategies.assertEquals((String)"foo", (String)pc.getUUIDHex());
        TestValueStrategies.assertEquals((String)"bar", (String)pc2.getUUIDHex());
        this.endEm((EntityManager)pm);
    }

    public void testSequence() {
        ValueStrategyPC pc = new ValueStrategyPC();
        ValueStrategyPC pc2 = new ValueStrategyPC();
        pc.setName("pc");
        pc2.setName("pc2");
        TestValueStrategies.assertEquals((int)0, (int)pc.getSequence());
        TestValueStrategies.assertEquals((int)0, (int)pc2.getSequence());
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.setOptimistic(true);
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        pm.persist((Object)pc2);
        int seq = pc.getSequence();
        TestValueStrategies.assertTrue((!pm.isStoreActive() ? 1 : 0) != 0);
        this.endTx((EntityManager)pm);
        int seq2 = pc2.getSequence();
        Object oid = pm.getObjectId((Object)pc);
        Object oid2 = pm.getObjectId((Object)pc2);
        this.endEm((EntityManager)pm);
        TestValueStrategies.assertTrue((seq > 0 ? 1 : 0) != 0);
        TestValueStrategies.assertTrue((seq2 > 0 ? 1 : 0) != 0);
        TestValueStrategies.assertTrue((seq != seq2 ? 1 : 0) != 0);
        pm = this.currentEntityManager();
        pc = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid);
        pc2 = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid2);
        TestValueStrategies.assertEquals((int)seq, (int)pc.getSequence());
        TestValueStrategies.assertEquals((int)seq2, (int)pc2.getSequence());
        this.startTx((EntityManager)pm);
        pc.setSequence(99);
        pc2.setSequence(100);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid);
        pc2 = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid2);
        TestValueStrategies.assertEquals((int)99, (int)pc.getSequence());
        TestValueStrategies.assertEquals((int)100, (int)pc2.getSequence());
        this.endEm((EntityManager)pm);
    }

    public void testVersion() {
        this.versionTest((EntityManagerFactory)this.getEmf());
    }

    public void testVersionDataCache() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openjpa.DataCache", "true");
        map.put("openjpa.RemoteCommitProvider", "sjvm");
        this.versionTest((EntityManagerFactory)this.getEmf(map));
    }

    private void versionTest(EntityManagerFactory pmf) {
        ValueStrategyPC pc = new ValueStrategyPC();
        pc.setName("pc");
        OpenJPAEntityManager pm = (OpenJPAEntityManager)pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        ClassMetaData meta = this.getConfiguration().getMetaDataRepositoryInstance().getMetaData(pc.getClass(), null, false);
        TestValueStrategies.assertNotNull((Object)meta.getVersionField());
        TestValueStrategies.assertEquals((String)"version", (String)meta.getVersionField().getName());
        TestValueStrategies.assertEquals((int)0, (int)pc.getVersion());
        this.endTx((EntityManager)pm);
        TestValueStrategies.assertEquals((int)1, (int)pc.getVersion());
        Object oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
        pm = (OpenJPAEntityManager)pmf.createEntityManager();
        pc = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid);
        TestValueStrategies.assertNotNull((Object)pc);
        TestValueStrategies.assertEquals((int)1, (int)pc.getVersion());
        this.startTx((EntityManager)pm);
        try {
            pc.setVersion(10);
            TestValueStrategies.fail((String)"Allowed change to version field.");
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        this.endTx((EntityManager)pm);
        TestValueStrategies.assertEquals((int)1, (int)pc.getVersion());
        this.endEm((EntityManager)pm);
        pm = (OpenJPAEntityManager)pmf.createEntityManager();
        pc = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid);
        TestValueStrategies.assertNotNull((Object)pc);
        TestValueStrategies.assertEquals((int)1, (int)pc.getVersion());
        this.startTx((EntityManager)pm);
        pc.setName("changed");
        pm.flush();
        TestValueStrategies.assertEquals((int)1, (int)pc.getVersion());
        this.endTx((EntityManager)pm);
        TestValueStrategies.assertEquals((String)"changed", (String)pc.getName());
        TestValueStrategies.assertEquals((int)2, (int)pc.getVersion());
        this.endEm((EntityManager)pm);
        pm = (OpenJPAEntityManager)pmf.createEntityManager();
        pc = (ValueStrategyPC)pm.find(ValueStrategyPC.class, oid);
        TestValueStrategies.assertNotNull((Object)pc);
        TestValueStrategies.assertEquals((int)2, (int)pc.getVersion());
        this.startTx((EntityManager)pm);
        pc.setName("changed2");
        pm.flush();
        TestValueStrategies.assertEquals((int)2, (int)pc.getVersion());
        this.rollbackTx((EntityManager)pm);
        TestValueStrategies.assertEquals((int)2, (int)pc.getVersion());
        this.endEm((EntityManager)pm);
    }

    public void testVersionDetach() {
        ValueStrategyPC pc = new ValueStrategyPC();
        ValueStrategyPC pc2 = new ValueStrategyPC();
        pc.setName("pc");
        pc2.setName("pc2");
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        pc.setName("changed");
        pc2.setName("changed2");
        this.endTx((EntityManager)pm);
        TestValueStrategies.assertEquals((int)2, (int)pc.getVersion());
        TestValueStrategies.assertEquals((int)2, (int)pc2.getVersion());
        ValueStrategyPC detached = (ValueStrategyPC)pm.detachCopy((Object)pc);
        ValueStrategyPC detached2 = (ValueStrategyPC)pm.detachCopy((Object)pc2);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (ValueStrategyPC)pm.merge((Object)detached);
        TestValueStrategies.assertEquals((int)2, (int)pc.getVersion());
        this.endTx((EntityManager)pm);
        TestValueStrategies.assertEquals((int)2, (int)pc.getVersion());
        this.endEm((EntityManager)pm);
        detached.setName("changed-detached");
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (ValueStrategyPC)pm.merge((Object)detached);
        TestValueStrategies.assertEquals((int)2, (int)pc.getVersion());
        this.endTx((EntityManager)pm);
        TestValueStrategies.assertEquals((int)3, (int)pc.getVersion());
        this.endEm((EntityManager)pm);
        detached.setName("stale");
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        try {
            pm.merge((Object)detached);
            this.endTx((EntityManager)pm);
            TestValueStrategies.fail((String)"Committed stale version.");
        }
        catch (OpenJPAException je) {
            // empty catch block
        }
        if (this.isActiveTx((EntityManager)pm)) {
            this.rollbackTx((EntityManager)pm);
        }
        this.endEm((EntityManager)pm);
        detached2.setName("changed2-detached");
        detached2.setVersion(99);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        try {
            pc2 = (ValueStrategyPC)pm.merge((Object)detached2);
            TestValueStrategies.assertEquals((int)2, (int)pc2.getVersion());
            this.endTx((EntityManager)pm);
            TestValueStrategies.assertEquals((int)3, (int)pc2.getVersion());
        }
        catch (OpenJPAException je) {
            // empty catch block
        }
        if (this.isActiveTx((EntityManager)pm)) {
            this.rollbackTx((EntityManager)pm);
        }
        this.endEm((EntityManager)pm);
    }

    public void testVersionRefresh() {
        ValueStrategyPC pc = new ValueStrategyPC();
        pc.setName("pc");
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        pc.setName("changed");
        this.endTx((EntityManager)pm);
        TestValueStrategies.assertEquals((int)2, (int)pc.getVersion());
        this.startTx((EntityManager)pm);
        pm.refresh((Object)pc);
        TestValueStrategies.assertEquals((int)2, (int)pc.getVersion());
        OpenJPAEntityManager pm2 = this.currentEntityManager();
        this.startTx((EntityManager)pm2);
        ValueStrategyPC pc2 = (ValueStrategyPC)pm2.find(ValueStrategyPC.class, pm2.getObjectId((Object)pc));
        pc2.setName("changed2");
        this.endTx((EntityManager)pm2);
        TestValueStrategies.assertEquals((int)3, (int)pc2.getVersion());
        this.endEm((EntityManager)pm2);
        pm.refresh((Object)pc);
        TestValueStrategies.assertEquals((int)3, (int)pc.getVersion());
        pc.setName("changed-1");
        pm.refresh((Object)pc);
        TestValueStrategies.assertEquals((int)3, (int)pc.getVersion());
        pc.setName("changed-2");
        this.endTx((EntityManager)pm);
        TestValueStrategies.assertEquals((int)4, (int)pc.getVersion());
        this.endEm((EntityManager)pm);
    }
}

