/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.util.HashMap;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.meta.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.meta.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.meta.common.apps.RuntimeTest3;

public class TestPersistentClasses
extends AbstractTestCase {
    public TestPersistentClasses(String test) {
        super(test, "metacactusapp");
    }

    private void assertClass(Class cls, OpenJPAConfiguration conf, boolean shouldExist) {
        this.assertClass(cls.getName(), conf, shouldExist);
    }

    private void assertClass(String clsName, OpenJPAConfiguration conf, boolean shouldExist) {
        Set names = conf.getMetaDataRepositoryInstance().getPersistentTypeNames(false, null);
        if (shouldExist) {
            TestPersistentClasses.assertTrue((String)("expected element " + clsName + " was not found in " + names), (boolean)names.contains(clsName));
        } else {
            TestPersistentClasses.assertTrue((String)("unexpected element " + clsName + " was found in " + names), (!names.contains(clsName) ? 1 : 0) != 0);
        }
    }

    public void testNoneConfigured() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openjpa.MetaDataFactory", "jpa");
        OpenJPAEntityManagerFactory pmf = this.getEmf(map);
        TestPersistentClasses.assertNull((Object)((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration().getMetaDataRepositoryInstance().getPersistentTypeNames(false, null));
        pmf.close();
    }

    public void testJPAClasspathScanner() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openjpa.MetaDataFactory", "jpa(ClasspathScan=src;jdk1.5-test)");
        OpenJPAEntityManagerFactory pmf = this.getEmf(map);
        this.assertClass(RuntimeTest1.class, ((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration(), false);
        this.assertClass(RuntimeTest2.class, ((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration(), false);
        this.assertClass("openjpa.meta.GenericFields", ((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration(), true);
        pmf.close();
    }

    public void testTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openjpa.MetaDataFactory", "jpa(Types=org.apache.openjpa.persistence.kernel.RuntimeTest1;org.apache.openjpa.persistence.kernel.RuntimeTest2)");
        OpenJPAEntityManagerFactory pmf = this.getEmf(map);
        this.assertClass(RuntimeTest1.class, ((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration(), true);
        this.assertClass(RuntimeTest2.class, ((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration(), true);
        this.assertClass(RuntimeTest3.class, ((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration(), false);
        pmf.close();
    }
}

