/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.embed.Address;
import org.apache.openjpa.persistence.embed.Geocode;
import org.apache.openjpa.persistence.enhance.identity.Book;
import org.apache.openjpa.persistence.enhance.identity.BookId;
import org.apache.openjpa.persistence.enhance.identity.Library;
import org.apache.openjpa.persistence.enhance.identity.Page;
import org.apache.openjpa.persistence.meta.AbstractManagedType;
import org.apache.openjpa.persistence.meta.Embed0;
import org.apache.openjpa.persistence.meta.Embed1;
import org.apache.openjpa.persistence.meta.ExplicitFieldAccess;
import org.apache.openjpa.persistence.meta.ExplicitPropertyAccess;
import org.apache.openjpa.persistence.meta.ImplicitFieldAccessBase;
import org.apache.openjpa.persistence.meta.ImplicitFieldAccessMappedSuperclass;
import org.apache.openjpa.persistence.meta.ImplicitFieldAccessSubclass;
import org.apache.openjpa.persistence.meta.MetamodelImpl;
import org.apache.openjpa.persistence.relations.OneOneChild;
import org.apache.openjpa.persistence.relations.OneOneParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMetamodel
extends SingleEMFTestCase {
    private static MetamodelImpl model;

    @Override
    public void setUp() {
        if (model == null) {
            super.setUp("openjpa.RuntimeUnenhancedClasses", "unsupported", "openjpa.DynamicEnhancementAgent", "false", ImplicitFieldAccessMappedSuperclass.class, ImplicitFieldAccessBase.class, ImplicitFieldAccessSubclass.class, ExplicitFieldAccess.class, ExplicitPropertyAccess.class, Embed0.class, Embed1.class, OneOneParent.class, OneOneChild.class, Book.class, Library.class, Page.class, Address.class, Geocode.class);
            this.emf.createEntityManager();
            model = (MetamodelImpl)this.emf.getMetamodel();
        }
    }

    public void testMetaModelForDomainClassesExist() {
        TestMetamodel.assertFalse((boolean)model.getEntities().isEmpty());
        TestMetamodel.assertFalse((boolean)model.getEmbeddables().isEmpty());
        TestMetamodel.assertFalse((boolean)model.getManagedTypes().isEmpty());
    }

    public void testMetaClassFieldsArePopulated() {
        EntityType m = model.entity(ImplicitFieldAccessSubclass.class);
        TestMetamodel.assertNotNull((Object)m);
        Class mCls = m.getJavaType();
        TestMetamodel.assertSame(ImplicitFieldAccessSubclass.class, (Object)mCls);
        Class m2Cls = model.getRepository().getMetaModel(mCls, true);
        TestMetamodel.assertNotNull((Object)m2Cls);
        try {
            Field f2 = this.getStaticField(m2Cls, "base");
            TestMetamodel.assertNotNull((Object)f2);
            Object value = f2.get(null);
            TestMetamodel.assertNotNull((Object)value);
            TestMetamodel.assertTrue((boolean)Attribute.class.isAssignableFrom(value.getClass()));
        }
        catch (Throwable t) {
            t.printStackTrace();
            TestMetamodel.fail();
        }
    }

    public void testDomainClassCategorizedInPersistentCategory() {
        this.assertCategory(Type.PersistenceType.MAPPED_SUPERCLASS, ImplicitFieldAccessMappedSuperclass.class);
        this.assertCategory(Type.PersistenceType.ENTITY, ImplicitFieldAccessBase.class);
        this.assertCategory(Type.PersistenceType.ENTITY, ImplicitFieldAccessSubclass.class);
        this.assertCategory(Type.PersistenceType.EMBEDDABLE, Embed0.class);
        this.assertCategory(Type.PersistenceType.EMBEDDABLE, Embed1.class);
        TestMetamodel.assertNotNull((Object)model.entity(ImplicitFieldAccessBase.class));
        TestMetamodel.assertNotNull((Object)model.entity(ImplicitFieldAccessSubclass.class));
        TestMetamodel.assertNotNull((Object)model.embeddable(Embed0.class));
        TestMetamodel.assertNotNull((Object)model.embeddable(Embed1.class));
        Set managedTypes = model.getManagedTypes();
        managedTypes.removeAll(model.getEmbeddables());
        managedTypes.removeAll(model.getEntities());
        TestMetamodel.assertNotNull((Object)model.managedType(ImplicitFieldAccessMappedSuperclass.class));
        TestMetamodel.assertTrue((boolean)managedTypes.contains(model.managedType(ImplicitFieldAccessMappedSuperclass.class)));
    }

    public void testGetAttributeByNameAndTypeFromMetaClass() {
        EntityType e0 = model.entity(ImplicitFieldAccessBase.class);
        TestMetamodel.assertNotNull((Object)e0.getAttribute("f0"));
        TestMetamodel.assertNotNull((Object)e0.getSingularAttribute("f0", String.class));
        TestMetamodel.assertSame((Object)e0.getAttribute("f0"), (Object)e0.getSingularAttribute("f0", String.class));
        try {
            e0.getSingularAttribute("f0", ExplicitFieldAccess.class);
            TestMetamodel.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        EntityType e1 = model.entity(ImplicitFieldAccessSubclass.class);
        TestMetamodel.assertNotNull((Object)e1.getAttribute("f0"));
    }

    public void testAttributeByDeclaration() {
        EntityType e0 = model.entity(ImplicitFieldAccessBase.class);
        EntityType e1 = model.entity(ImplicitFieldAccessSubclass.class);
        TestMetamodel.assertNotNull((Object)e0.getAttribute("f0"));
        TestMetamodel.assertNotNull((Object)e1.getAttribute("f0"));
        System.err.println(e0.getAttribute("f0"));
        TestMetamodel.assertNotNull((Object)e0.getSingularAttribute("f0", String.class));
        TestMetamodel.assertNotNull((Object)e1.getSingularAttribute("f0", String.class));
        TestMetamodel.assertSame((Object)e0.getAttribute("f0"), (Object)e0.getSingularAttribute("f0", String.class));
        TestMetamodel.assertSame((Object)e1.getAttribute("f0"), (Object)e1.getSingularAttribute("f0", String.class));
        TestMetamodel.assertNotSame((Object)e0.getAttribute("f0"), (Object)e1.getAttribute("f0"));
        TestMetamodel.assertNotSame((Object)e0.getSingularAttribute("f0", String.class), (Object)e1.getSingularAttribute("f0", String.class));
        TestMetamodel.assertNotNull((Object)e0.getDeclaredAttribute("f0"));
        try {
            e1.getDeclaredAttribute("f0");
            TestMetamodel.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPCCollection() {
        EntityType e0 = model.entity(ImplicitFieldAccessBase.class);
        EntityType r1 = model.entity(ExplicitFieldAccess.class);
        CollectionAttribute relColl = e0.getCollection("collectionRelation", ExplicitFieldAccess.class);
        TestMetamodel.assertEquals((Object)PluralAttribute.CollectionType.COLLECTION, (Object)relColl.getCollectionType());
        TestMetamodel.assertEquals((Object)e0, (Object)relColl.getDeclaringType());
        TestMetamodel.assertEquals((Object)r1, (Object)relColl.getElementType());
        TestMetamodel.assertEquals(ExplicitFieldAccess.class, (Object)relColl.getBindableJavaType());
        TestMetamodel.assertEquals((Object)Bindable.BindableType.PLURAL_ATTRIBUTE, (Object)relColl.getBindableType());
        TestMetamodel.assertEquals((Object)Attribute.PersistentAttributeType.ONE_TO_MANY, (Object)relColl.getPersistentAttributeType());
    }

    public void testPCList() {
        EntityType e0 = model.entity(ImplicitFieldAccessBase.class);
        EntityType r1 = model.entity(ExplicitFieldAccess.class);
        ListAttribute relList = e0.getList("listRelation", ExplicitFieldAccess.class);
        TestMetamodel.assertEquals((Object)PluralAttribute.CollectionType.LIST, (Object)relList.getCollectionType());
        TestMetamodel.assertEquals((Object)e0, (Object)relList.getDeclaringType());
        TestMetamodel.assertEquals((Object)r1, (Object)relList.getElementType());
        TestMetamodel.assertEquals(ExplicitFieldAccess.class, (Object)relList.getBindableJavaType());
        TestMetamodel.assertEquals((Object)Bindable.BindableType.PLURAL_ATTRIBUTE, (Object)relList.getBindableType());
        TestMetamodel.assertEquals((Object)Attribute.PersistentAttributeType.ONE_TO_MANY, (Object)relList.getPersistentAttributeType());
    }

    public void testPCSet() {
        EntityType e0 = model.entity(ImplicitFieldAccessBase.class);
        EntityType r1 = model.entity(ExplicitFieldAccess.class);
        SetAttribute relSet = e0.getSet("setRelation", ExplicitFieldAccess.class);
        TestMetamodel.assertEquals((Object)PluralAttribute.CollectionType.SET, (Object)relSet.getCollectionType());
        TestMetamodel.assertEquals((Object)e0, (Object)relSet.getDeclaringType());
        TestMetamodel.assertEquals((Object)r1, (Object)relSet.getElementType());
        TestMetamodel.assertEquals(ExplicitFieldAccess.class, (Object)relSet.getBindableJavaType());
        TestMetamodel.assertEquals((Object)Bindable.BindableType.PLURAL_ATTRIBUTE, (Object)relSet.getBindableType());
        TestMetamodel.assertEquals((Object)Attribute.PersistentAttributeType.ONE_TO_MANY, (Object)relSet.getPersistentAttributeType());
    }

    public void testDeclaredFields() {
        EntityType e1 = model.entity(ImplicitFieldAccessSubclass.class);
        Set all = e1.getAttributes();
        Set decl = e1.getDeclaredAttributes();
        TestMetamodel.assertTrue((String)("All fields " + all + "\r\nDeclared fields " + decl + "\r\n" + "expecetd not all fields as declared"), (all.size() > decl.size() ? 1 : 0) != 0);
    }

    public void testNonExistentField() {
        EntityType e0 = model.entity(ImplicitFieldAccessBase.class);
        EntityType e1 = model.entity(ImplicitFieldAccessSubclass.class);
        this.assertFails((ManagedType<?>)e0, "xyz", false);
        this.assertFails((ManagedType<?>)e1, "f0", true);
    }

    public void testAttributeGettersForValidInput() {
        EntityType subClass = model.entity(ImplicitFieldAccessSubclass.class);
        EntityType superClass = model.entity(ImplicitFieldAccessBase.class);
        TestMetamodel.assertEquals((Object)superClass, (Object)subClass.getSupertype());
        TestMetamodel.assertNotNull((Object)subClass.getAttribute("f0"));
        TestMetamodel.assertNotNull((Object)superClass.getAttribute("f0"));
        TestMetamodel.assertNotNull((Object)subClass.getAttribute("mapRelationKeyEmbedded"));
        TestMetamodel.assertNotNull((Object)subClass.getAttributes());
        TestMetamodel.assertNotNull((Object)superClass.getAttributes());
        TestMetamodel.assertEquals((int)14, (int)subClass.getAttributes().size());
        TestMetamodel.assertEquals((int)12, (int)superClass.getAttributes().size());
        TestMetamodel.assertNotNull((Object)superClass.getCollection("collectionRelation"));
        TestMetamodel.assertNotNull((Object)superClass.getCollection("collectionRelation", ExplicitFieldAccess.class));
        TestMetamodel.assertNotNull((Object)subClass.getPluralAttributes());
        TestMetamodel.assertNotNull((Object)superClass.getPluralAttributes());
        TestMetamodel.assertEquals((int)6, (int)subClass.getPluralAttributes().size());
        TestMetamodel.assertEquals((int)5, (int)superClass.getPluralAttributes().size());
        TestMetamodel.assertNotNull((Object)subClass.getDeclaredAttribute("mapRelationKeyEmbedded"));
        TestMetamodel.assertNotNull((Object)subClass.getDeclaredAttributes());
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredAttributes());
        TestMetamodel.assertEquals((int)2, (int)subClass.getDeclaredAttributes().size());
        TestMetamodel.assertEquals((int)9, (int)superClass.getDeclaredAttributes().size());
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredCollection("collectionRelation"));
        TestMetamodel.assertNotNull((Object)subClass.getDeclaredPluralAttributes());
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredPluralAttributes());
        TestMetamodel.assertEquals((int)1, (int)subClass.getDeclaredPluralAttributes().size());
        TestMetamodel.assertEquals((int)5, (int)superClass.getDeclaredPluralAttributes().size());
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredList("listRelation"));
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredList("listRelation", ExplicitFieldAccess.class));
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredMap("mapRelationKeyBasic"));
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredMap("mapRelationKeyBasic", Integer.class, ExplicitFieldAccess.class));
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredSet("setRelation"));
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredSet("setRelation", ExplicitFieldAccess.class));
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredSingularAttribute("one2oneRelation"));
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredSingularAttribute("one2oneRelation", ExplicitFieldAccess.class));
        TestMetamodel.assertNotNull((Object)superClass.getDeclaredSingularAttributes());
        TestMetamodel.assertNotNull((Object)subClass.getList("listRelation"));
        TestMetamodel.assertNotNull((Object)subClass.getList("listRelation", ExplicitFieldAccess.class));
        TestMetamodel.assertNotNull((Object)subClass.getMap("mapRelationKeyBasic"));
        TestMetamodel.assertNotNull((Object)subClass.getMap("mapRelationKeyBasic", Integer.class, ExplicitFieldAccess.class));
        TestMetamodel.assertNotNull((Object)subClass.getPersistenceType());
        TestMetamodel.assertNotNull((Object)subClass.getSet("setRelation"));
        TestMetamodel.assertNotNull((Object)subClass.getSet("setRelation", ExplicitFieldAccess.class));
        TestMetamodel.assertNotNull((Object)subClass.getSingularAttribute("one2oneRelation"));
        TestMetamodel.assertNotNull((Object)subClass.getSingularAttribute("one2oneRelation", ExplicitFieldAccess.class));
        TestMetamodel.assertNotNull((Object)subClass.getSingularAttributes());
    }

    public void testSimpleIdAttributes() {
        EntityType entity = model.entity(OneOneParent.class);
        for (Attribute a : entity.getAttributes()) {
            System.err.println(a.getName());
        }
        TestMetamodel.assertNotNull((Object)entity.getId(Long.TYPE));
        TestMetamodel.assertNotNull((Object)entity.getDeclaredId(Long.TYPE));
        TestMetamodel.assertTrue((boolean)entity.hasSingleIdAttribute());
        TestMetamodel.assertEquals(Long.TYPE, (Object)entity.getIdType().getJavaType());
    }

    public void testVersionAttributes() {
        EntityType entity = model.entity(OneOneParent.class);
        for (Attribute a : entity.getAttributes()) {
            System.err.println(a.getName());
        }
        TestMetamodel.assertNotNull((Object)entity.getVersion(Integer.class));
        TestMetamodel.assertNotNull((Object)entity.getDeclaredVersion(Integer.class));
        TestMetamodel.assertTrue((boolean)entity.hasVersionAttribute());
    }

    public void testIdClassAttributes() {
        EntityType entity = model.entity(Book.class);
        TestMetamodel.assertEquals((int)2, (int)entity.getIdClassAttributes().size());
        TestMetamodel.assertNotNull((Object)entity.getId(String.class));
        TestMetamodel.assertNotNull((Object)entity.getId(Library.class));
        TestMetamodel.assertNotNull((Object)entity.getDeclaredId(String.class));
        TestMetamodel.assertNotNull((Object)entity.getDeclaredId(Library.class));
        TestMetamodel.assertEquals(BookId.class, (Object)entity.getIdType().getJavaType());
        TestMetamodel.assertFalse((boolean)entity.hasSingleIdAttribute());
    }

    public void testBasicAttributeType() {
        EntityType e0 = model.entity(ImplicitFieldAccessBase.class);
        SingularAttribute pInt = e0.getDeclaredSingularAttribute("primitiveInt");
        TestMetamodel.assertEquals((Object)Attribute.PersistentAttributeType.BASIC, (Object)pInt.getPersistentAttributeType());
    }

    public void testEmbeddedAttributeType() {
        EntityType type = model.entity(Address.class);
        Attribute.PersistentAttributeType attr = type.getAttribute("geocode").getPersistentAttributeType();
        TestMetamodel.assertEquals((Object)Attribute.PersistentAttributeType.EMBEDDED, (Object)attr);
    }

    public void testNotFoundErrorMessage() {
        EntityType e0 = model.entity(ImplicitFieldAccessBase.class);
        String name = "unknown";
        try {
            Method[] getters = new Method[]{e0.getClass().getMethod("getAttribute", String.class), e0.getClass().getMethod("getCollection", String.class), e0.getClass().getMethod("getList", String.class), e0.getClass().getMethod("getSet", String.class), e0.getClass().getMethod("getSingularAttribute", String.class), e0.getClass().getMethod("getDeclaredAttribute", String.class), e0.getClass().getMethod("getDeclaredCollection", String.class), e0.getClass().getMethod("getDeclaredList", String.class), e0.getClass().getMethod("getDeclaredSet", String.class), e0.getClass().getMethod("getDeclaredSingularAttribute", String.class), e0.getClass().getMethod("getAttribute", String.class, Class.class), e0.getClass().getMethod("getCollection", String.class, Class.class), e0.getClass().getMethod("getList", String.class, Class.class), e0.getClass().getMethod("getSet", String.class, Class.class), e0.getClass().getMethod("getSingularAttribute", String.class, Class.class), e0.getClass().getMethod("getDeclaredAttribute", String.class, Class.class), e0.getClass().getMethod("getDeclaredCollection", String.class, Class.class), e0.getClass().getMethod("getDeclaredList", String.class, Class.class), e0.getClass().getMethod("getDeclaredSet", String.class, Class.class), e0.getClass().getMethod("getDeclaredSingularAttribute", String.class, Class.class), e0.getClass().getMethod("getMap", String.class), e0.getClass().getMethod("getMap", String.class, Class.class, Class.class), e0.getClass().getMethod("getDeclaredMap", String.class), e0.getClass().getMethod("getDeclaredMap", String.class, Class.class, Class.class)};
            for (int i = 0; i < getters.length; ++i) {
                Object[] args = i < 10 ? new Object[]{name} : (i < 20 ? new Object[]{name, Object.class} : (i % 2 == 0 ? new Object[]{name} : new Object[]{name, Object.class, String.class}));
                try {
                    getters[i].invoke((Object)e0, args);
                    TestMetamodel.fail();
                    continue;
                }
                catch (InvocationTargetException e) {
                    System.err.println("Expeceted:" + e.getTargetException());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestMetamodel.fail();
        }
    }

    void assertFails(ManagedType<?> type, String name, boolean dec) {
        try {
            Attribute a = dec ? type.getDeclaredAttribute(name) : type.getAttribute(name);
            TestMetamodel.fail((String)("Expected to fail " + name + " on " + type));
        }
        catch (IllegalArgumentException e) {
            System.err.println("Expeceted:" + e);
        }
    }

    Type.PersistenceType categorize(Class<?> c) {
        AbstractManagedType type = (AbstractManagedType)model.getType(c);
        ClassMetaData meta = type.meta;
        return MetamodelImpl.getPersistenceType((ClassMetaData)meta);
    }

    void assertCategory(Type.PersistenceType category, Class<?> cls) {
        TestMetamodel.assertEquals((String)cls.toString(), (Object)category, (Object)this.categorize(cls));
    }

    Field getStaticField(Class<?> cls, String name) {
        try {
            Field[] fds;
            for (Field f : fds = cls.getDeclaredFields()) {
                int mods = f.getModifiers();
                if (!f.getName().equals(name) || !Modifier.isStatic(mods)) continue;
                return f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

