/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.util.Collection;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.meta.MdrTestEntity;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestMetaDataRepository
extends AbstractPersistenceTestCase {
    private final String PU_NAME = "mdr-pu";

    public void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreloadBasic() {
        OpenJPAEntityManagerFactorySPI emf = null;
        try {
            emf = this.createNamedEMF("mdr-pu", "openjpa.MetaDataRepository", "Preload=true");
            MetaDataRepository mdr = emf.getConfiguration().getMetaDataRepositoryInstance();
            ClassMetaData metadata = mdr.getCachedMetaData(MdrTestEntity.class);
            TestMetaDataRepository.assertNotNull((Object)metadata);
            Collection aliases = mdr.getAliasNames();
            TestMetaDataRepository.assertTrue((boolean)aliases.contains("MdrTestEntity"));
            QueryMetaData query = mdr.getCachedQueryMetaData(MdrTestEntity.class, "query");
            TestMetaDataRepository.assertNotNull((Object)query);
        }
        finally {
            if (emf != null) {
                emf.close();
            }
        }
    }
}

