/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.merge;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.merge.model.Toy;
import org.apache.openjpa.persistence.merge.model.ToyBox;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestCascadeOneToManyMerge
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(Toy.class, ToyBox.class, CLEAR_TABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneToManyCascadeMergeSingleEntity() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            Toy toy = new Toy(1);
            toy.setToyName("Toy Train");
            ToyBox toybox = new ToyBox(1);
            toybox.setOwnerName("Evan");
            toy.setToybox(toybox);
            toybox.getToyList().add(toy);
            em.getTransaction().begin();
            ToyBox mergedToyBox = (ToyBox)em.merge((Object)toybox);
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.merge() didn't return null", (Object)mergedToyBox);
            ToyBox toyboxFind = (ToyBox)em.find(ToyBox.class, (Object)1);
            Toy toyFind = (Toy)em.find(Toy.class, (Object)1);
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.find() for ToyBox(id=1) did not return null.", (Object)toyboxFind);
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.find() for Toy(id=1) did not return null.", (Object)toyFind);
            TestCascadeOneToManyMerge.assertTrue((String)"Assert em.find() returns the ToyBox returned by em.merge()", (mergedToyBox == toyboxFind ? 1 : 0) != 0);
            TestCascadeOneToManyMerge.assertTrue((String)"Assert tahat ToyBox(id=1).toyList is size 1", (toyboxFind.getToyList().size() == 1 ? 1 : 0) != 0);
            TestCascadeOneToManyMerge.assertTrue((String)"Assert that ToyBox(id=1).toyList contains the managed Toy(id=1).", (boolean)toyboxFind.getToyList().contains(toyFind));
            TestCascadeOneToManyMerge.assertTrue((String)"Assert that Toy(id=1) references the managed ToyBox(id=1).", (toyFind.getToybox() == toyboxFind ? 1 : 0) != 0);
            em.getTransaction().commit();
            em.clear();
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.find(Toy.class, 1) doesn't return null.", (Object)em.find(Toy.class, (Object)1));
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.find(ToyBox.class, 1) doesn't return null.", (Object)em.find(ToyBox.class, (Object)1));
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneToManyCascadeMergeDoubleEntity() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            Toy toy1 = new Toy(1);
            toy1.setToyName("Toy Train");
            Toy toy2 = new Toy(2);
            toy2.setToyName("Toy Plane");
            ToyBox toybox = new ToyBox(1);
            toybox.setOwnerName("Evan");
            toy1.setToybox(toybox);
            toy2.setToybox(toybox);
            toybox.getToyList().add(toy1);
            toybox.getToyList().add(toy2);
            em.getTransaction().begin();
            ToyBox mergedToyBox = (ToyBox)em.merge((Object)toybox);
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.merge() didn't return null", (Object)mergedToyBox);
            em.getTransaction().commit();
            ToyBox toyboxFind = (ToyBox)em.find(ToyBox.class, (Object)1);
            Toy toy1Find = (Toy)em.find(Toy.class, (Object)1);
            Toy toy2Find = (Toy)em.find(Toy.class, (Object)2);
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.find() for ToyBox(id=1) did not return null.", (Object)toyboxFind);
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.find() for Toy(id=1) did not return null.", (Object)toy1Find);
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.find() for Toy(id=2) did not return null.", (Object)toy2Find);
            TestCascadeOneToManyMerge.assertTrue((String)"Assert em.find() returns the ToyBox returned by em.merge()", (mergedToyBox == toyboxFind ? 1 : 0) != 0);
            TestCascadeOneToManyMerge.assertTrue((String)"Assert tahat ToyBox(id=1).toyList is size 2", (toyboxFind.getToyList().size() == 2 ? 1 : 0) != 0);
            TestCascadeOneToManyMerge.assertTrue((String)"Assert that ToyBox(id=1).toyList contains the managed Toy(id=1).", (boolean)toyboxFind.getToyList().contains(toy1Find));
            TestCascadeOneToManyMerge.assertTrue((String)"Assert that ToyBox(id=1).toyList contains the managed Toy(id=2).", (boolean)toyboxFind.getToyList().contains(toy2Find));
            TestCascadeOneToManyMerge.assertTrue((String)"Assert that Toy(id=1) references the managed ToyBox(id=1).", (toy1Find.getToybox() == toyboxFind ? 1 : 0) != 0);
            TestCascadeOneToManyMerge.assertTrue((String)"Assert that Toy(id=2) references the managed ToyBox(id=1).", (toy2Find.getToybox() == toyboxFind ? 1 : 0) != 0);
            em.clear();
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.find(Toy.class, 1) doesn't return null.", (Object)em.find(Toy.class, (Object)1));
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.find(Toy.class, 2) doesn't return null.", (Object)em.find(Toy.class, (Object)2));
            TestCascadeOneToManyMerge.assertNotNull((String)"Assert em.find(ToyBox.class, 1) doesn't return null.", (Object)em.find(ToyBox.class, (Object)1));
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

