/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lifecycle;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.BidiChild;
import org.apache.openjpa.persistence.relations.BidiParent;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestMergeAndPersistWithManagedRelation
extends SingleEMTestCase {
    private long childId;

    public void setUp() {
        this.setUp(BidiParent.class, BidiChild.class, CLEAR_TABLES);
        BidiChild child = new BidiChild();
        child.setName("child");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)child);
        em.getTransaction().commit();
        this.childId = child.getId();
        em.close();
    }

    public void testPersistWithManagedRelation() {
        BidiParent parent = new BidiParent();
        BidiChild child = (BidiChild)this.em.find(BidiChild.class, (Object)this.childId);
        parent.setOneToOneChild(child);
        this.em.getTransaction().begin();
        this.em.persist((Object)parent);
        this.em.getTransaction().commit();
        long id = parent.getId();
        this.em.close();
        this.em = this.emf.createEntityManager();
        parent = (BidiParent)this.em.find(BidiParent.class, (Object)id);
        TestMergeAndPersistWithManagedRelation.assertNotNull((Object)parent);
    }

    public void testMergeWithManagedRelation() {
        BidiParent parent = new BidiParent();
        BidiChild child = (BidiChild)this.em.find(BidiChild.class, (Object)this.childId);
        parent.setOneToOneChild(child);
        this.em.getTransaction().begin();
        parent = (BidiParent)this.em.merge((Object)parent);
        this.em.getTransaction().commit();
        long id = parent.getId();
        this.em.close();
        this.em = this.emf.createEntityManager();
        parent = (BidiParent)this.em.find(BidiParent.class, (Object)id);
        TestMergeAndPersistWithManagedRelation.assertNotNull((Object)parent);
    }
}

