/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel.common.apps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.kernel.common.apps.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@FetchGroups(value={@FetchGroup(name="State_OutgoingTransitions", attributes={@FetchAttribute(name="outgoingTransitions")}), @FetchGroup(name="State_IncomingTransitions", attributes={@FetchAttribute(name="incomingTransitions")})})
public class State
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(length=64)
    private String name;
    @OneToMany(mappedBy="fromState", cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    private List<Transition> outgoingTransitions;
    @OneToMany(mappedBy="toState", cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    private List<Transition> incomingTransitions;

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Transition> getOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    public void addOutgoingTransitions(Transition outgoingTransition) {
        if (this.outgoingTransitions == null) {
            this.outgoingTransitions = new ArrayList<Transition>();
        }
        this.outgoingTransitions.add(outgoingTransition);
    }

    public List<Transition> getIncomingTransitions() {
        return this.incomingTransitions;
    }

    public void addIncomingTransitions(Transition incomingTransition) {
        if (this.incomingTransitions == null) {
            this.incomingTransitions = new ArrayList<Transition>();
        }
        this.incomingTransitions.add(incomingTransition);
    }
}

