/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel.common.apps;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.kernel.common.apps.PCAddress;

@Entity
@FetchGroups(value={@FetchGroup(name="detail+children-names", fetchGroups={"detail"}), @FetchGroup(name="detail", fetchGroups={"default"}, attributes={@FetchAttribute(name="address")}), @FetchGroup(name="detail+children-list", fetchGroups={"detail"}, attributes={@FetchAttribute(name="children")}), @FetchGroup(name="person.address", attributes={@FetchAttribute(name="address")})})
public class PCPerson {
    private String name;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    private PCAddress address;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    private PCPerson parent;
    @ManyToMany(cascade={CascadeType.PERSIST})
    private Set<PCPerson> children;

    protected PCPerson() {
    }

    public PCPerson(String name) {
        this.setName(name);
    }

    public PCAddress getAddress() {
        return this.address;
    }

    public void setAddress(PCAddress address) {
        this.address = address;
    }

    public Set getChildren() {
        return this.children;
    }

    public void setChildren(Set children) {
        this.children = children;
    }

    public void addChildren(PCPerson child) {
        if (this.children == null) {
            this.children = new HashSet<PCPerson>();
        }
        this.children.add(child);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PCPerson getParent() {
        return this.parent;
    }

    public void setParent(PCPerson parent) {
        this.parent = parent;
    }

    public static Object reflect(PCPerson instance, String name) {
        if (instance == null) {
            return null;
        }
        try {
            return PCPerson.class.getDeclaredField(name).get(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

