/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel.common.apps;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.kernel.common.apps.PCFile;

@Entity
@FetchGroups(value={@FetchGroup(name="name+parent+grandparent", attributes={@FetchAttribute(name="_name"), @FetchAttribute(name="_parent", recursionDepth=2)}), @FetchGroup(name="name+parent+grandparent+greatgrandparent", attributes={@FetchAttribute(name="_name"), @FetchAttribute(name="_parent", recursionDepth=3)}), @FetchGroup(name="name+parent", attributes={@FetchAttribute(name="_name"), @FetchAttribute(name="_parent")}), @FetchGroup(name="allparents", attributes={@FetchAttribute(name="_name"), @FetchAttribute(name="_parent", recursionDepth=-1)}), @FetchGroup(name="name", attributes={@FetchAttribute(name="_name")})})
public class PCDirectory {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @Column(name="name_col")
    private String _name;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    private PCDirectory _parent;
    @ManyToMany(cascade={CascadeType.PERSIST})
    private Set<PCDirectory> _children;
    @ManyToMany(cascade={CascadeType.PERSIST})
    private Set<PCFile> _files;

    public PCDirectory() {
    }

    public PCDirectory(String name) {
        this._name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this._name;
    }

    public PCDirectory getParent() {
        return this._parent;
    }

    public Set getChildren() {
        return this._children;
    }

    public Set getFiles() {
        return this._files;
    }

    public void add(PCDirectory dir) {
        if (dir == null) {
            throw new NullPointerException("null directory");
        }
        if (dir.getParent() != null && dir.getParent() != this) {
            throw new IllegalArgumentException(dir + " has a different parent");
        }
        if (this._children == null) {
            this._children = new HashSet<PCDirectory>();
        }
        this._children.add(dir);
        dir._parent = this;
    }

    public PCFile add(String name) {
        if (name == null) {
            throw new NullPointerException("null file");
        }
        PCFile file = new PCFile(this, name);
        if (this._files == null) {
            this._files = new HashSet<PCFile>();
        }
        if (this._files.contains(file)) {
            throw new IllegalArgumentException("duplicate file" + file);
        }
        this._files.add(file);
        return file;
    }

    public boolean isChild(PCDirectory dir, boolean recurse) {
        if (this._children == null) {
            return false;
        }
        if (this._children.contains(dir)) {
            return true;
        }
        if (recurse) {
            for (PCDirectory child : this._children) {
                if (!child.isChild(dir, recurse)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isChild(PCFile file, boolean recurse) {
        if (this._files != null && this._files.contains(file)) {
            return true;
        }
        if (this._children == null) {
            return false;
        }
        if (recurse) {
            for (PCDirectory child : this._children) {
                if (!child.isChild(file, recurse)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object reflect(PCDirectory instance, String name) {
        if (instance == null) {
            return null;
        }
        try {
            return PCDirectory.class.getDeclaredField(name).get(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

