/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel.common.apps;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.kernel.common.apps.PCCompany;
import org.apache.openjpa.persistence.kernel.common.apps.PCEmployee;

@Entity
@FetchGroups(value={@FetchGroup(name="department.employees", attributes={@FetchAttribute(name="employees")}), @FetchGroup(name="department.company", attributes={@FetchAttribute(name="company")})})
public class PCDepartment {
    private String name;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    private PCCompany company;
    @ManyToMany(cascade={CascadeType.PERSIST})
    private Set<PCEmployee> employees;

    public PCDepartment() {
    }

    public PCDepartment(String name) {
        this.setName(name);
    }

    public PCCompany getCompany() {
        return this.company;
    }

    public void setCompany(PCCompany company) {
        this.company = company;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set getEmployees() {
        return this.employees;
    }

    public void setEmployees(Set employees) {
        this.employees = employees;
    }

    public void addEmployee(PCEmployee emp) {
        if (this.employees == null) {
            this.employees = new HashSet<PCEmployee>();
        }
        this.employees.add(emp);
        emp.setDepartment(this);
    }

    public boolean contains(PCEmployee emp) {
        return this.employees != null && this.employees.contains(emp);
    }

    public static Object reflect(PCDepartment instance, String name) {
        if (instance == null) {
            return null;
        }
        try {
            return PCDepartment.class.getDeclaredField(name).get(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

