/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel.common.apps;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.kernel.common.apps.PCAddress;
import org.apache.openjpa.persistence.kernel.common.apps.PCDepartment;

@Entity
@FetchGroups(value={@FetchGroup(name="company.address", attributes={@FetchAttribute(name="address")}), @FetchGroup(name="company.departments", attributes={@FetchAttribute(name="departments")}), @FetchGroup(name="default", postLoad=false, attributes={@FetchAttribute(name="name")})})
public class PCCompany {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private String name;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    private PCAddress address;
    @ManyToMany(cascade={CascadeType.PERSIST})
    private Set<PCDepartment> departments;

    public PCCompany() {
    }

    public PCCompany(String name) {
        this.setName(name);
    }

    public int getId() {
        return this.id;
    }

    public PCAddress getAddress() {
        return this.address;
    }

    public void setAddress(PCAddress address) {
        this.address = address;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set getDepartments() {
        return this.departments;
    }

    public void setDepartments(Set departments) {
        this.departments = departments;
    }

    public void addDepartment(PCDepartment dept) {
        if (this.departments == null) {
            this.departments = new HashSet<PCDepartment>();
        }
        this.departments.add(dept);
        dept.setCompany(this);
    }

    public boolean contains(PCDepartment dept) {
        return this.departments != null && this.departments.contains(dept);
    }

    public static Object reflect(PCCompany instance, String name) {
        if (instance == null) {
            return null;
        }
        try {
            return PCCompany.class.getDeclaredField(name).get(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

