/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.RestoreStateType;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.ModRuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.ModRuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.PersistenceAware;

public class TestTransition2
extends BaseKernelTest {
    private boolean supportsPessimistic = true;
    private int _id = 0;

    public TestTransition2() {
    }

    public TestTransition2(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        OpenJPAEntityManager pm;
        super.setUp(ModRuntimeTest1.class, ModRuntimeTest2.class, PersistenceAware.class);
        try {
            pm = this.getPM(false, false);
            this.supportsPessimistic = !pm.getOptimistic();
            pm.close();
        }
        catch (Exception e) {
            this.supportsPessimistic = false;
        }
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = this.createTest2();
        pm.persist((Object)b);
        this._id = b.getId();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testFlagTransitions1() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        ModRuntimeTest2 b = this.createTest2();
        this.assertTransient(b);
        this.assertTransient(b.getSelfOneOne());
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        this.assertPersistent(b, true, true, false, true);
        this.rollbackTx((EntityManager)pm);
        this.assertTransient(b);
        this.assertTransient(b.getSelfOneOne());
        this.endEm((EntityManager)pm);
    }

    public void testFlagTransitions2() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        ModRuntimeTest2 b = this.createTest2();
        this.assertTransient(b);
        this.assertTransient(b.getSelfOneOne());
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        this.assertPersistent(b, true, true, false, true);
        this.endTx((EntityManager)pm);
        this.assertPersistent(b, false, false, false, false);
        this.assertPersistent(b.getSelfOneOne(), false, false, false, false);
        this.endEm((EntityManager)pm);
    }

    public void testFlagTransitions3() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertPersistent(b, true, false, false, false);
        this.assertPersistent(b.getSelfOneOne(), true, false, false, false);
        this.endTx((EntityManager)pm);
        this.assertPersistent(b, false, false, false, false);
        this.assertPersistent(b.getSelfOneOne(), false, false, false, false);
        this.endEm((EntityManager)pm);
    }

    public void testFlagTransitions4() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertPersistent(b, true, false, false, false);
        this.assertPersistent(b.getSelfOneOne(), true, false, false, false);
        this.rollbackTx((EntityManager)pm);
        this.assertPersistent(b, false, false, false, false);
        this.assertPersistent(b.getSelfOneOne(), false, false, false, false);
        this.endEm((EntityManager)pm);
    }

    public void testFlagTransitions5() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertPersistent(b, false, false, false, false);
        this.assertPersistent(b.getSelfOneOne(), false, false, false, false);
        this.endEm((EntityManager)pm);
    }

    public void testFlagTransitions6() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        ModRuntimeTest1 parent = b.getSelfOneOne();
        pm.remove((Object)b);
        this.assertPersistent(b, true, false, true, true);
        this.assertPersistent(parent, true, false, false, false);
        this.endTx((EntityManager)pm);
        this.assertTransient(b);
        this.assertPersistent(parent, false, false, false, false);
        this.endEm((EntityManager)pm);
    }

    public void testFlagTransitions7() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        ModRuntimeTest1 parent = b.getSelfOneOne();
        pm.remove((Object)b);
        this.assertPersistent(b, true, false, true, true);
        this.assertPersistent(parent, true, false, false, false);
        this.rollbackTx((EntityManager)pm);
        this.assertPersistent(b, false, false, false, false);
        this.assertPersistent(parent, false, false, false, false);
        this.endEm((EntityManager)pm);
    }

    public void testStateTransitions1() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        pm.persist((Object)b.getSelfOneOne());
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testStateTransitions2() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.endTx((EntityManager)pm);
        this.assertTest2Changed(b, false);
        this.endEm((EntityManager)pm);
    }

    public void testStateTransitions3() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.changeTest2(b);
        this.endTx((EntityManager)pm);
        this.assertTest2Changed(b, false);
        this.endEm((EntityManager)pm);
    }

    public void testStateTransitions3a() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.changeTest2(b);
        this.endTx((EntityManager)pm);
        this.assertTest2Changed(b, false);
        this.endEm((EntityManager)pm);
    }

    public void testStateTransitions4() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testStateTransitions4a() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testStateTransitions5() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        ModRuntimeTest1 parent = b.getSelfOneOne();
        TestTransition2.assertNotNull((String)"parent is null", (Object)parent);
        pm.remove((Object)b);
        this.endTx((EntityManager)pm);
        TestTransition2.assertEquals((String)"PARENT", (String)parent.getStringField());
        TestTransition2.assertNull((Object)b.getStringField());
        TestTransition2.assertEquals((int)0, (int)b.getIntField());
        TestTransition2.assertNull((Object)b.getSelfOneOne());
    }

    public void testStateTransitions6() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertTest2Orig(b);
        pm.remove((Object)b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testOptStateTransitions1() throws Exception {
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        pm.persist((Object)b.getSelfOneOne());
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testOptStateTransitions2() throws Exception {
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.endTx((EntityManager)pm);
        this.assertTest2Changed(b, false);
        this.endEm((EntityManager)pm);
    }

    public void testOptStateTransitions3() throws Exception {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.endTx((EntityManager)pm);
        this.assertTest2Changed(b, false);
        this.endEm((EntityManager)pm);
    }

    public void testOptStateTransitions4() throws Exception {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testOptStateTransitions5() throws Exception {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        ModRuntimeTest1 parent = b.getSelfOneOne();
        TestTransition2.assertNotNull((String)"parent is null", (Object)parent);
        pm.remove((Object)b);
        this.endTx((EntityManager)pm);
        TestTransition2.assertEquals((String)"PARENT", (String)parent.getStringField());
        TestTransition2.assertNull((Object)b.getStringField());
        TestTransition2.assertEquals((int)0, (int)b.getIntField());
        TestTransition2.assertNull((Object)b.getSelfOneOne());
    }

    public void testOptStateTransitions6() throws Exception {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        pm.remove((Object)b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testOptRetainStateTransitions1() throws Exception {
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(true, true);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        pm.persist((Object)b.getSelfOneOne());
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testOptRetainStateTransitions2() throws Exception {
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(true, true);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.endTx((EntityManager)pm);
        this.assertTest2Changed(b, true);
        this.endEm((EntityManager)pm);
    }

    public void testOptRetainStateTransitions3() throws Exception {
        OpenJPAEntityManager pm = this.getPM(true, true);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.endTx((EntityManager)pm);
        this.assertTest2Changed(b, true);
        this.endEm((EntityManager)pm);
    }

    public void testOptRetainStateTransitions4() throws Exception {
        OpenJPAEntityManager pm = this.getPM(true, true);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testOptRetainStateTransitions5() throws Exception {
        OpenJPAEntityManager pm = this.getPM(true, true);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        ModRuntimeTest1 parent = b.getSelfOneOne();
        TestTransition2.assertNotNull((String)"parent is null", (Object)parent);
        pm.remove((Object)b);
        this.endTx((EntityManager)pm);
        TestTransition2.assertEquals((String)"PARENT", (String)parent.getStringField());
        TestTransition2.assertNull((Object)b.getStringField());
        TestTransition2.assertEquals((int)0, (int)b.getIntField());
        TestTransition2.assertNull((Object)b.getSelfOneOne());
    }

    public void testOptRetainStateTransitions6() throws Exception {
        OpenJPAEntityManager pm = this.getPM(true, true);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        pm.remove((Object)b);
        this.rollbackTx((EntityManager)pm);
        if (pm.getRestoreState() != RestoreStateType.NONE) {
            this.assertTest2Orig(b);
        } else {
            TestTransition2.assertNull((Object)b.getStringField());
        }
        this.endEm((EntityManager)pm);
    }

    public void testRetainStateTransitions1() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(false, true);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        pm.persist((Object)b.getSelfOneOne());
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testRetainStateTransitions2() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(false, true);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.endTx((EntityManager)pm);
        this.assertTest2Changed(b, true);
        this.endEm((EntityManager)pm);
    }

    public void testRetainStateTransitions3() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, true);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.endTx((EntityManager)pm);
        this.assertTest2Changed(b, true);
        this.endEm((EntityManager)pm);
    }

    public void testRetainStateTransitions4() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, true);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        this.assertTest2Orig(b);
        this.changeTest2(b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testRetainStateTransitions5() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, true);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        ModRuntimeTest1 parent = b.getSelfOneOne();
        TestTransition2.assertNotNull((String)"parent is null", (Object)parent);
        pm.remove((Object)b);
        this.endTx((EntityManager)pm);
        TestTransition2.assertEquals((String)"PARENT", (String)parent.getStringField());
        TestTransition2.assertNull((Object)b.getStringField());
        TestTransition2.assertEquals((int)0, (int)b.getIntField());
        TestTransition2.assertNull((Object)b.getSelfOneOne());
    }

    public void testRetainStateTransitions6() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        OpenJPAEntityManager pm = this.getPM(false, true);
        this.startTx((EntityManager)pm);
        ModRuntimeTest2 b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)this._id);
        pm.remove((Object)b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testTransientStateTransitions1() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        pm.transactional((Object)b, true);
        pm.transactional((Object)b.getSelfOneOne(), true);
        this.changeTest2(b);
        this.rollbackTx((EntityManager)pm);
        this.assertTest2Orig(b);
        this.endEm((EntityManager)pm);
    }

    public void testTransientStateTransitions2() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        pm.transactional((Object)b, true);
        pm.transactional((Object)b.getSelfOneOne(), true);
        this.changeTest2(b);
        this.endTx((EntityManager)pm);
        this.assertTest2Changed(b, false);
        this.endEm((EntityManager)pm);
    }

    public void testTransientStateTransitions3() throws Exception {
        if (!this.supportsPessimistic) {
            return;
        }
        ModRuntimeTest2 b = this.createTest2();
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        pm.persist((Object)b);
        int oid = b.getId();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM(false, false);
        b = (ModRuntimeTest2)pm.find(ModRuntimeTest2.class, (Object)oid);
        pm.retrieve((Object)b);
        this.endEm((EntityManager)pm);
        TestTransition2.assertNotNull((String)"b is null", (Object)b.getSelfOneOne());
    }

    private ModRuntimeTest2 createTest2() {
        return this.createTest2("NAME", 50);
    }

    private ModRuntimeTest2 createTest2(String str, int i) {
        return this.createTest2(new ModRuntimeTest2(str, i));
    }

    private ModRuntimeTest2 createTest2(ModRuntimeTest2 b) {
        ModRuntimeTest1 parent = new ModRuntimeTest1("PARENT", 70);
        b.setSelfOneOne(parent);
        return b;
    }

    private void changeTest2(ModRuntimeTest2 b) {
        PersistenceAware.setModTransString(b, "999");
        b.setStringField("CHANGED");
        b.setIntField(1000);
        b.getSelfOneOne().setStringField("PCHANGED");
        b.setSelfOneOne(null);
    }

    private void assertTest2Changed(ModRuntimeTest2 b, boolean retainValues) {
        if (retainValues) {
            TestTransition2.assertEquals((String)"999", (String)PersistenceAware.getModTransString(b));
        }
        TestTransition2.assertEquals((String)"CHANGED", (String)b.getStringField());
        TestTransition2.assertEquals((int)1000, (int)b.getIntField());
        TestTransition2.assertNull((Object)b.getSelfOneOne());
    }

    private void assertTest2Orig(ModRuntimeTest2 b) {
        TestTransition2.assertEquals((String)"NAME", (String)b.getStringField());
        TestTransition2.assertEquals((int)50, (int)b.getIntField());
        TestTransition2.assertNotNull((Object)b.getSelfOneOne());
        TestTransition2.assertEquals((String)"PARENT", (String)b.getSelfOneOne().getStringField());
        TestTransition2.assertEquals((String)"transactional field 'transString' was not the same as it was originally. Ensure that openjpa.kernel.PersistenceAware is enhanced. It is persistence-aware, so will not be enhanced by commands like jdoc $(find test -name '*.jdo').", null, (String)PersistenceAware.getModTransString(b));
    }

    public void assertTransient(Object a) {
        OpenJPAEntityManager pm = this.currentEntityManager();
        TestTransition2.assertTrue((!pm.isPersistent(a) ? 1 : 0) != 0);
        TestTransition2.assertTrue((!pm.isTransactional(a) ? 1 : 0) != 0);
        TestTransition2.assertTrue((!pm.isNewlyPersistent(a) ? 1 : 0) != 0);
        TestTransition2.assertTrue((!pm.isDirty(a) ? 1 : 0) != 0);
        TestTransition2.assertTrue((!pm.isRemoved(a) ? 1 : 0) != 0);
        TestTransition2.assertNull((Object)pm.getObjectId(a));
        TestTransition2.assertNull((Object)OpenJPAPersistence.getEntityManager((Object)a));
        this.endEm((EntityManager)pm);
    }

    public void assertPersistent(Object a, boolean isTrans, boolean isNew, boolean isDeleted, boolean isDirty) {
        OpenJPAEntityManager pm = this.currentEntityManager();
        TestTransition2.assertTrue((boolean)pm.isPersistent(a));
        TestTransition2.assertTrue((boolean)(a instanceof PersistenceCapable));
        TestTransition2.assertEquals((boolean)isTrans, (boolean)pm.isTransactional(a));
        TestTransition2.assertEquals((boolean)isNew, (boolean)pm.isNewlyPersistent(a));
        TestTransition2.assertEquals((boolean)isDeleted, (boolean)pm.isRemoved(a));
        TestTransition2.assertEquals((isDirty || isNew || isDeleted ? 1 : 0) != 0, (boolean)pm.isDirty(a));
        TestTransition2.assertNotNull((Object)pm.getObjectId(a));
        TestTransition2.assertNotNull((Object)OpenJPAPersistence.getEntityManager((Object)a));
        this.endEm((EntityManager)pm);
    }
}

