/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.BlobTest;

public class TestStoreBlob
extends BaseKernelTest {
    public TestStoreBlob() {
    }

    public TestStoreBlob(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(BlobTest.class);
    }

    public void testStoreBlob() {
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        BlobTest blob = new BlobTest();
        byte[] bytes = new byte[2048];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = TestStoreBlob.randomByte();
        }
        blob.setBlob(bytes);
        pm.persist((Object)blob);
        int id = blob.getId();
        this.endTx((EntityManager)pm);
        byte[] b1 = blob.getBlob();
        this.endEm((EntityManager)pm);
        pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        BlobTest blob2 = (BlobTest)pm.find(BlobTest.class, (Object)id);
        byte[] b2 = blob2.getBlob();
        TestStoreBlob.assertNotNull((String)"Original blob was null", (Object)b1);
        TestStoreBlob.assertNotNull((String)"Retrieved blob was null", (Object)b2);
        TestStoreBlob.assertEquals((String)"Blob length was not the same", (int)b1.length, (int)b2.length);
        this.assertBytesEquals("Blob contents did not match", b1, b2);
        this.endTx((EntityManager)pm);
    }

    private void assertBytesEquals(String str, byte[] a, byte[] b) {
        for (int i = 0; i < a.length; ++i) {
            TestStoreBlob.assertEquals((String)(str + " [" + i + "]"), (byte)a[i], (byte)b[i]);
        }
    }
}

