/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.ModRuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.ModRuntimeTest2;

public class TestStateManagerImplData
extends BaseKernelTest {
    ClassMetaData _meta;
    Boolean _f1;
    Boolean _f3;

    public TestStateManagerImplData() {
    }

    public TestStateManagerImplData(String test) {
        super(test);
    }

    public void setUp() throws Exception {
        super.setUp(ModRuntimeTest1.class, ModRuntimeTest2.class);
    }

    public void setUpMetaData(ClassMetaData meta) {
        this._meta = meta;
        this._f1 = this._meta.getField(1).usesImplData();
        this._f3 = this._meta.getField(3).usesImplData();
        this._meta.getField(1).setUsesImplData(Boolean.TRUE);
        this._meta.getField(3).setUsesImplData(null);
    }

    public void tearDownMetaData() {
        this._meta.getField(1).setUsesImplData(this._f1);
        this._meta.getField(3).setUsesImplData(this._f3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImplData() {
        ModRuntimeTest1 pc = new ModRuntimeTest1();
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        OpenJPAStateManager sm = this.getStateManager(pc, (EntityManager)pm);
        this.setUpMetaData(sm.getMetaData());
        try {
            Object inst = new Object();
            TestStateManagerImplData.assertNull((Object)sm.getImplData());
            TestStateManagerImplData.assertNull((Object)sm.setImplData(inst, true));
            TestStateManagerImplData.assertEquals((Object)inst, (Object)sm.getImplData());
            TestStateManagerImplData.assertTrue((boolean)sm.isImplDataCacheable());
            TestStateManagerImplData.assertEquals((Object)inst, (Object)sm.setImplData(null, false));
            TestStateManagerImplData.assertNull((Object)sm.getImplData());
            TestStateManagerImplData.assertFalse((boolean)sm.isImplDataCacheable());
            sm.setImplData(inst, false);
            TestStateManagerImplData.assertFalse((boolean)sm.isImplDataCacheable());
            Object f1 = new Object();
            Object f3 = new Object();
            TestStateManagerImplData.assertNull((Object)sm.getImplData(1));
            TestStateManagerImplData.assertFalse((boolean)sm.isImplDataCacheable(1));
            TestStateManagerImplData.assertNull((Object)sm.setImplData(1, f1));
            TestStateManagerImplData.assertEquals((Object)f1, (Object)sm.getImplData(1));
            TestStateManagerImplData.assertTrue((!sm.isImplDataCacheable(1) ? 1 : 0) != 0);
            TestStateManagerImplData.assertEquals((Object)f1, (Object)sm.setImplData(1, null));
            TestStateManagerImplData.assertNull((Object)sm.getImplData(1));
            TestStateManagerImplData.assertFalse((boolean)sm.isImplDataCacheable(1));
            sm.setImplData(1, f1);
            TestStateManagerImplData.assertNull((Object)sm.setImplData(3, f3));
            TestStateManagerImplData.assertEquals((Object)f3, (Object)sm.getImplData(3));
            TestStateManagerImplData.assertTrue((boolean)sm.isImplDataCacheable(3));
            TestStateManagerImplData.assertEquals((Object)f1, (Object)sm.getImplData(1));
            this.endTx((EntityManager)pm);
            TestStateManagerImplData.assertEquals((Object)inst, (Object)sm.getImplData());
            TestStateManagerImplData.assertNull((Object)sm.getImplData(1));
            TestStateManagerImplData.assertNull((Object)sm.getImplData(3));
            this.endEm((EntityManager)pm);
        }
        finally {
            this.tearDownMetaData();
        }
    }

    public void testNotClearedIfRetainValues() {
        this.notClearedIfRetainValuesTest(true);
        this.notClearedIfRetainValuesTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notClearedIfRetainValuesTest(boolean optimistic) {
        ModRuntimeTest1 pc = new ModRuntimeTest1("pc", 1);
        int key = 1;
        Object value = new Object();
        OpenJPAEntityManager pm = this.getPM(optimistic, true);
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        OpenJPAStateManager sm = this.getStateManager(pc, (EntityManager)pm);
        TestStateManagerImplData.assertNotNull((Object)sm);
        this.setUpMetaData(sm.getMetaData());
        try {
            sm.setImplData(key, value);
            TestStateManagerImplData.assertEquals((Object)value, (Object)sm.getImplData(key));
            this.endTx((EntityManager)pm);
            TestStateManagerImplData.assertEquals((Object)value, (Object)sm.getImplData(key));
            this.startTx((EntityManager)pm);
            pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
            sm = this.getStateManager(pc, (EntityManager)pm);
            TestStateManagerImplData.assertNotNull((Object)sm);
            if (pm.getOptimistic()) {
                TestStateManagerImplData.assertEquals((Object)value, (Object)sm.getImplData(key));
            } else {
                TestStateManagerImplData.assertNull((Object)sm.getImplData(key));
            }
            this.endTx((EntityManager)pm);
            this.endEm((EntityManager)pm);
        }
        finally {
            this.tearDownMetaData();
        }
        pm = this.getPM(optimistic, true);
        pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
        sm = this.getStateManager(pc, (EntityManager)pm);
        TestStateManagerImplData.assertNotNull((Object)sm);
        this.setUpMetaData(sm.getMetaData());
        try {
            sm.setImplData(key, value);
            TestStateManagerImplData.assertEquals((Object)value, (Object)sm.getImplData(key));
            this.startTx((EntityManager)pm);
            pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
            if (pm.getOptimistic()) {
                TestStateManagerImplData.assertEquals((Object)value, (Object)sm.getImplData(key));
            } else {
                TestStateManagerImplData.assertNull((Object)sm.getImplData(key));
                sm.setImplData(key, value);
            }
            this.endTx((EntityManager)pm);
            TestStateManagerImplData.assertEquals((Object)value, (Object)sm.getImplData(key));
            this.endEm((EntityManager)pm);
        }
        finally {
            this.tearDownMetaData();
        }
    }
}

