/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.math.BigInteger;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.EntityManager;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.AllFieldTypesTest;

public class TestSpecialNumbers
extends BaseKernelTest {
    public TestSpecialNumbers() {
    }

    public TestSpecialNumbers(String name) {
        super(name);
    }

    public void setUp() {
        try {
            this.deleteAll(AllFieldTypesTest.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testShortMax() {
        AllFieldTypesTest aftt = new AllFieldTypesTest();
        aftt.setTestshort((short)Short.MAX_VALUE);
        this.saveAndQuery(aftt, "testshort = :param", new Short(Short.MAX_VALUE));
    }

    public void testShortMin() {
        AllFieldTypesTest aftt = new AllFieldTypesTest();
        aftt.setTestshort((short)Short.MIN_VALUE);
        try {
            this.saveAndQuery(aftt, "testshort = :param", new Short(Short.MIN_VALUE));
        }
        catch (Throwable t) {
            this.bug(AbstractTestCase.Platform.EMPRESS, 889, t, "Empress cannot store min values");
        }
    }

    public void testLongMax() {
        AllFieldTypesTest aftt = new AllFieldTypesTest();
        aftt.setTestlong(Long.MAX_VALUE);
        this.saveAndQuery(aftt, "testlong = :param", new Long(Long.MAX_VALUE));
    }

    public void testLongMin() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestlong(Long.MIN_VALUE);
            this.saveAndQuery(aftt, "testlong = :param", new Long(Long.MIN_VALUE));
        }
        catch (Throwable t) {
            this.bug(AbstractTestCase.Platform.HYPERSONIC, 474, t, "Some databases cannot store Long.MIN_VALUE");
        }
    }

    public void testIntegerMax() {
        AllFieldTypesTest aftt = new AllFieldTypesTest();
        aftt.setTestint(Integer.MAX_VALUE);
        this.saveAndQuery(aftt, "testint = :param", new Integer(Integer.MAX_VALUE));
    }

    public void testIntegerMin() {
        AllFieldTypesTest aftt = new AllFieldTypesTest();
        aftt.setTestint(Integer.MIN_VALUE);
        try {
            this.saveAndQuery(aftt, "testint = :param", new Integer(Integer.MIN_VALUE));
        }
        catch (Throwable t) {
            this.bug(AbstractTestCase.Platform.EMPRESS, 889, t, "Empress cannot store min values");
        }
    }

    public void testFloatMax() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestfloat(Float.MAX_VALUE);
            this.saveAndQuery(aftt, "testfloat = :param", new Float(Float.MAX_VALUE));
        }
        catch (Exception e) {
            this.bug(EnumSet.of(AbstractTestCase.Platform.POSTGRESQL, AbstractTestCase.Platform.DB2, AbstractTestCase.Platform.MYSQL, AbstractTestCase.Platform.DERBY), 494, (Throwable)e, "Some datastores cannot store Float.MAX_VALUE");
        }
    }

    public void testFloatMin() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestfloat(Float.MIN_VALUE);
            this.saveAndQuery(aftt, "testfloat = :param", new Float(Float.MIN_VALUE));
        }
        catch (Exception e) {
            this.bug(EnumSet.of(AbstractTestCase.Platform.POSTGRESQL, AbstractTestCase.Platform.SQLSERVER, AbstractTestCase.Platform.DB2, AbstractTestCase.Platform.INFORMIX, AbstractTestCase.Platform.DERBY), 494, (Throwable)e, "Some databases cannot store Float.MIN_VALUE");
        }
        catch (AssertionFailedError e) {
            this.bug(EnumSet.of(AbstractTestCase.Platform.MYSQL, AbstractTestCase.Platform.SQLSERVER), 494, (Throwable)e, "Some databases cannot store Float.MIN_VALUE");
        }
    }

    public void testFloatNaN() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestfloat(Float.NaN);
            this.saveAndQuery(aftt, "testfloat = :param", new Float(Float.NaN));
        }
        catch (Throwable t) {
            this.bug(461, t, "NaN problems");
        }
    }

    public void testFloatNegativeInfinity() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestfloat(Float.NEGATIVE_INFINITY);
            this.saveAndQuery(aftt, "testfloat = :param", new Float(Float.NEGATIVE_INFINITY));
        }
        catch (Exception e) {
            this.bug(EnumSet.of(AbstractTestCase.Platform.POINTBASE, new AbstractTestCase.Platform[]{AbstractTestCase.Platform.POSTGRESQL, AbstractTestCase.Platform.MYSQL, AbstractTestCase.Platform.DB2, AbstractTestCase.Platform.ORACLE, AbstractTestCase.Platform.INFORMIX, AbstractTestCase.Platform.DERBY, AbstractTestCase.Platform.SQLSERVER}), 494, (Throwable)e, "Some databases cannot store Float.NEGATIVE_INFINITY");
        }
    }

    public void testFloatPostivieInfinity() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestfloat(Float.POSITIVE_INFINITY);
            this.saveAndQuery(aftt, "testfloat = :param", new Float(Float.POSITIVE_INFINITY));
        }
        catch (Exception e) {
            this.bug(EnumSet.of(AbstractTestCase.Platform.POINTBASE, new AbstractTestCase.Platform[]{AbstractTestCase.Platform.POSTGRESQL, AbstractTestCase.Platform.MYSQL, AbstractTestCase.Platform.DB2, AbstractTestCase.Platform.ORACLE, AbstractTestCase.Platform.INFORMIX, AbstractTestCase.Platform.DERBY, AbstractTestCase.Platform.SQLSERVER}), 494, (Throwable)e, "Some databases cannot store Float.POSITIVE_INFINITY");
        }
    }

    public void testDoubleMax() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestdouble(Double.MAX_VALUE);
            this.saveAndQuery(aftt, "testdouble = :param", new Double(Double.MAX_VALUE));
        }
        catch (Exception e) {
            this.bug(EnumSet.of(AbstractTestCase.Platform.POINTBASE, new AbstractTestCase.Platform[]{AbstractTestCase.Platform.MYSQL, AbstractTestCase.Platform.ORACLE, AbstractTestCase.Platform.POSTGRESQL, AbstractTestCase.Platform.EMPRESS, AbstractTestCase.Platform.DB2, AbstractTestCase.Platform.INFORMIX, AbstractTestCase.Platform.DERBY}), 494, (Throwable)e, "Some databases cannot store Double.MAX_VALUE");
        }
    }

    public void testDoubleMin() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestdouble(Double.MIN_VALUE);
            this.saveAndQuery(aftt, "testdouble = :param", new Double(Double.MIN_VALUE));
        }
        catch (Exception e) {
            this.bug(EnumSet.of(AbstractTestCase.Platform.POSTGRESQL, new AbstractTestCase.Platform[]{AbstractTestCase.Platform.SQLSERVER, AbstractTestCase.Platform.ORACLE, AbstractTestCase.Platform.EMPRESS, AbstractTestCase.Platform.DB2, AbstractTestCase.Platform.INFORMIX, AbstractTestCase.Platform.DERBY}), 494, (Throwable)e, "Some databases cannot store Double.MIN_VALUE");
        }
        catch (AssertionFailedError e) {
            this.bug(AbstractTestCase.Platform.MYSQL, 494, (Throwable)e, "Some databases cannot store Double.MIN_VALUE");
        }
    }

    public void testDoubleNaN() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestdouble(Double.NaN);
            this.saveAndQuery(aftt, "testdouble = :param", new Double(Double.NaN));
        }
        catch (Throwable t) {
            this.bug(461, t, "NaN problems");
        }
    }

    public void testDoubleNegativeInfinity() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestdouble(Double.NEGATIVE_INFINITY);
            this.saveAndQuery(aftt, "testdouble = :param", new Double(Double.NEGATIVE_INFINITY));
        }
        catch (Throwable t) {
            this.bug(461, t, "infinity problems");
        }
    }

    public void testDoublePostivieInfinity() {
        try {
            AllFieldTypesTest aftt = new AllFieldTypesTest();
            aftt.setTestdouble(Double.POSITIVE_INFINITY);
            this.saveAndQuery(aftt, "testdouble = :param", new Double(Double.POSITIVE_INFINITY));
        }
        catch (Throwable t) {
            this.bug(461, t, "infinity problems");
        }
    }

    public void testByteMin() {
        AllFieldTypesTest aftt = new AllFieldTypesTest();
        aftt.setTestbyte((byte)-128);
        try {
            this.saveAndQuery(aftt, "testbyte = :param", new Byte(-128));
        }
        catch (Throwable t) {
            this.bug(AbstractTestCase.Platform.EMPRESS, 889, t, "Empress cannot store min values");
        }
    }

    public void testByteMax() {
        AllFieldTypesTest aftt = new AllFieldTypesTest();
        aftt.setTestbyte((byte)127);
        this.saveAndQuery(aftt, "testbyte = :param", new Byte(127));
    }

    public void testZeroBigInteger() {
        AllFieldTypesTest aftt = new AllFieldTypesTest();
        aftt.setTestBigInteger(BigInteger.ZERO);
        this.saveAndQuery(aftt, "testBigInteger = :param", BigInteger.ZERO);
    }

    public void testOneBigInteger() {
        AllFieldTypesTest aftt = new AllFieldTypesTest();
        aftt.setTestBigInteger(BigInteger.ONE);
        this.saveAndQuery(aftt, "testBigInteger = :param", BigInteger.ONE);
    }

    private void saveAndQuery(Object obj, String query, Object param) {
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist(obj);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        OpenJPAQuery q = pm.createQuery("select o from " + obj.getClass().getName() + " o where " + query);
        q.setParameter("param", param);
        List c = q.getResultList();
        this.assertSize(1, c);
        this.endEm((EntityManager)pm);
    }
}

