/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.persistence.EntityManager;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.SCOTest;

public class TestSecondClassValues
extends BaseKernelTest {
    public static double DOUBLE_PRECISION = 1.0E-4;
    public static float FLOAT_PRECISION = 1.0E-4f;
    private OpenJPAEntityManager pm;
    private String newline = System.getProperty("line.separator");

    public TestSecondClassValues() {
    }

    public TestSecondClassValues(String name) {
        super(name);
    }

    public void setUp() {
        this.pm = this.getPM(true, false);
    }

    private int rnd() {
        return (int)(Math.random() * 20.0) + 5;
    }

    public void testMapDeletion() {
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        SCOTest test = new SCOTest();
        pm.persist((Object)test);
        Map map = new HashMap<String, Integer>();
        map.put("foo", new Integer(1));
        map.put("bar", new Integer(2));
        for (int i = 0; i < 10; ++i) {
            map.put("baz#" + i, new Integer(i));
        }
        test.setStrIntMap(map);
        Object id = pm.getObjectId((Object)test);
        this.endTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        test = (SCOTest)pm.find(SCOTest.class, id);
        TestSecondClassValues.assertNotNull((Object)test);
        map = test.getStrIntMap();
        TestSecondClassValues.assertEquals((int)12, (int)map.size());
        TestSecondClassValues.assertEquals((Object)new Integer(1), map.get("foo"));
        TestSecondClassValues.assertEquals((Object)new Integer(2), map.get("bar"));
        map.remove("bar");
        this.endTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        test = (SCOTest)pm.find(SCOTest.class, id);
        TestSecondClassValues.assertNotNull((Object)test);
        map = test.getStrIntMap();
        TestSecondClassValues.assertEquals((int)11, (int)map.size());
        TestSecondClassValues.assertEquals((Object)new Integer(1), map.get("foo"));
        TestSecondClassValues.assertTrue((map.get("bar") == null ? 1 : 0) != 0);
        map.clear();
        this.endTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        test = (SCOTest)pm.find(SCOTest.class, id);
        TestSecondClassValues.assertNotNull((Object)test);
        map = test.getStrIntMap();
        TestSecondClassValues.assertEquals((int)0, (int)map.size());
        this.endTx((EntityManager)pm);
    }

    public void testStringCollection() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.rnd(); ++i) {
            list.add(TestSecondClassValues.randomString());
        }
        this.saveSecondClassCollection(list);
    }

    public void testLongCollection() throws Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < this.rnd(); ++i) {
            list.add(TestSecondClassValues.randomLong());
        }
        try {
            this.saveSecondClassCollection(list);
        }
        catch (AssertionFailedError afe) {
            this.bug(AbstractTestCase.Platform.EMPRESS, 889, (Throwable)afe, "Empress cannot store large long values");
        }
    }

    public void testShortCollection() throws Exception {
        ArrayList<Short> list = new ArrayList<Short>();
        for (int i = 0; i < this.rnd(); ++i) {
            list.add(TestSecondClassValues.randomShort());
        }
        this.saveSecondClassCollection(list);
    }

    public void testBigIntegerCollection() throws Exception {
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        for (int i = 0; i < this.rnd(); ++i) {
            list.add(TestSecondClassValues.randomBigInteger());
        }
        this.saveSecondClassCollection(list);
    }

    public void testBigDecimalCollection() throws Exception {
        try {
            ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
            for (int i = 0; i < this.rnd(); ++i) {
                list.add(TestSecondClassValues.randomBigDecimal());
            }
            this.saveSecondClassCollection(list);
        }
        catch (AssertionFailedError e) {
            this.bug(3, e, "Precision loss for BigDecimals");
        }
    }

    public void testIntegerCollection() throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.rnd(); ++i) {
            list.add(TestSecondClassValues.randomInt());
        }
        this.saveSecondClassCollection(list);
    }

    public void testByteCollection() throws Exception {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (int i = 0; i < this.rnd(); ++i) {
            list.add(TestSecondClassValues.randomByte());
        }
        this.saveSecondClassCollection(list);
    }

    public void testBooleanCollection() throws Exception {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (int i = 0; i < this.rnd(); ++i) {
            list.add(TestSecondClassValues.randomBoolean());
        }
        this.saveSecondClassCollection(list, true);
    }

    public void testFloatCollection() throws Exception {
        try {
            ArrayList<Float> list = new ArrayList<Float>();
            for (int i = 0; i < this.rnd(); ++i) {
                list.add(TestSecondClassValues.randomFloat());
            }
            this.saveSecondClassCollection(list);
        }
        catch (AssertionFailedError afe) {
            this.bug(3, afe, "Loss of BigDecimal precision");
        }
    }

    public void testDoubleCollection() throws Exception {
        try {
            ArrayList<Double> list = new ArrayList<Double>();
            for (int i = 0; i < this.rnd(); ++i) {
                list.add(TestSecondClassValues.randomDouble());
            }
            this.saveSecondClassCollection(list);
        }
        catch (AssertionFailedError afe) {
            this.bug(3, afe, "Loss of BigDecimal precision");
        }
    }

    public void testDateCollection() throws Exception {
        ArrayList<Date> list = new ArrayList<Date>();
        for (int i = 0; i < this.rnd(); ++i) {
            list.add(TestSecondClassValues.randomDate());
        }
        list.add(new Date(472246800000L));
        this.saveSecondClassCollection(list);
    }

    public void testBigDecimalBigIntegerMap() throws Exception {
        try {
            HashMap<BigDecimal, BigInteger> map = new HashMap<BigDecimal, BigInteger>();
            for (int i = 0; i < this.rnd(); ++i) {
                map.put(TestSecondClassValues.randomBigDecimal(), TestSecondClassValues.randomBigInteger());
            }
            this.saveSecondClassMap(map);
        }
        catch (AssertionFailedError e) {
            this.bug(3, e, "Precision loss for BigDecimals");
        }
    }

    public void testStrIntMap() throws Exception {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.rnd(); ++i) {
            map.put(TestSecondClassValues.randomString(), TestSecondClassValues.randomInt());
        }
        this.saveSecondClassMap(map);
    }

    public void testIntLongMap() throws Exception {
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        for (int i = 0; i < this.rnd(); ++i) {
            map.put(TestSecondClassValues.randomInt(), TestSecondClassValues.randomLong());
        }
        try {
            this.saveSecondClassMap(map);
        }
        catch (AssertionFailedError afe) {
            this.bug(AbstractTestCase.Platform.EMPRESS, 889, (Throwable)afe, "Empress cannot store large long values");
        }
    }

    public void testFloatByteMap() throws Exception {
        try {
            HashMap<Float, Byte> map = new HashMap<Float, Byte>();
            for (int i = 0; i < this.rnd(); ++i) {
                map.put(TestSecondClassValues.randomFloat(), TestSecondClassValues.randomByte());
            }
            this.saveSecondClassMap(map);
        }
        catch (AssertionFailedError afe) {
            this.bug(3, afe, "Loss of BigDecimal precision");
        }
    }

    public void testByteDoubleMap() throws Exception {
        try {
            HashMap<Byte, Double> map = new HashMap<Byte, Double>();
            for (int i = 0; i < this.rnd(); ++i) {
                map.put(TestSecondClassValues.randomByte(), TestSecondClassValues.randomDouble());
            }
            this.saveSecondClassMap(map);
        }
        catch (AssertionFailedError afe) {
            this.bug(3, afe, "Loss of BigDecimal precision");
        }
    }

    public void testDoubleCharMap() throws Exception {
        try {
            HashMap<Double, Character> map = new HashMap<Double, Character>();
            for (int i = 0; i < this.rnd(); ++i) {
                map.put(TestSecondClassValues.randomDouble(), TestSecondClassValues.randomChar());
            }
            this.saveSecondClassMap(map);
        }
        catch (AssertionFailedError afe) {
            this.bug(3, afe, "Loss of BigDecimal precision");
        }
    }

    public void testCharBooleanMap() throws Exception {
        HashMap<Character, Boolean> map = new HashMap<Character, Boolean>();
        for (int i = 0; i < this.rnd(); ++i) {
            map.put(TestSecondClassValues.randomChar(), TestSecondClassValues.randomBoolean());
        }
        this.saveSecondClassMap(map);
    }

    public void testDateStrMap() throws Exception {
        HashMap<Date, String> map = new HashMap<Date, String>();
        for (int i = 0; i < this.rnd(); ++i) {
            map.put(TestSecondClassValues.randomDate(), TestSecondClassValues.randomString());
        }
        map.put(new Date(472246800000L), "PostgreSQL ain't gonna like this date");
        TestSecondClassValues.assertNotNull((String)"map is null testDateStrMap", map);
        this.saveSecondClassMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSecondClassMap(HashMap map) throws Exception {
        try {
            this.saveSecondClassMapInternal(map);
        }
        finally {
            this.commit();
        }
    }

    private void commit() {
        try {
            TestSecondClassValues.assertNotNull((Object)this.pm);
            this.endTx((EntityManager)this.pm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void begin() {
        this.commit();
        this.pm = this.getPM(true, false);
        this.startTx((EntityManager)this.pm);
    }

    private void saveSecondClassMapInternal(HashMap map) throws Exception {
        this.begin();
        SCOTest test = new SCOTest();
        this.pm.persist((Object)test);
        int testID = test.getId();
        TestSecondClassValues.assertNotNull((String)"Passed Map is null", (Object)map);
        Map smap = this.setGetMap(test, map, true);
        TestSecondClassValues.assertNotNull((String)"Map is null in setGetMap", (Object)smap);
        this.commit();
        for (Object keyToDelete : ((HashMap)map.clone()).keySet()) {
            this.begin();
            SCOTest retrievedObject = (SCOTest)this.pm.find(SCOTest.class, (Object)testID);
            TestSecondClassValues.assertNotNull((String)"retrievedObject Obj is null - saveSecondClassMapInternal", (Object)retrievedObject);
            Map retrievedMap = this.setGetMap(retrievedObject, map, false);
            TestSecondClassValues.assertNotNull((String)"retrievedMap Obj is null - saveSecondClassMapInternal", (Object)retrievedMap);
            TestSecondClassValues.assertTrue((map.size() != 0 ? 1 : 0) != 0);
            TestSecondClassValues.assertEquals((int)map.size(), (int)retrievedMap.size());
            TestSecondClassValues.assertTrue((String)"Incompatible types", (boolean)map.keySet().iterator().next().getClass().isAssignableFrom(retrievedMap.keySet().iterator().next().getClass()));
            for (Object key : map.keySet()) {
                TestSecondClassValues.assertTrue((key != null ? 1 : 0) != 0);
                TestSecondClassValues.assertTrue((map.get(key) != null ? 1 : 0) != 0);
                if (key.getClass() == Date.class && retrievedMap.get(key) == null) {
                    this.getLog().trace((Object)("Time: " + ((Date)key).getTime()));
                    this.getLog().trace((Object)("List: " + this.dumpDates(retrievedMap.keySet())));
                }
                if (key.getClass() != Double.class && key.getClass() != Float.class && key.getClass() != BigDecimal.class || retrievedMap.get(key) == null) {
                    // empty if block
                }
                TestSecondClassValues.assertTrue((String)("The original map contained the object (class=" + key.getClass().getName() + ", value=" + key.toString() + "), but that object was null " + "in the map that was retrieved " + this.dump(retrievedMap.keySet()) + "."), (retrievedMap.get(key) != null ? 1 : 0) != 0);
                this.assertClassAndValueEquals(map.get(key), retrievedMap.get(key));
            }
            map.remove(keyToDelete);
            retrievedMap.remove(keyToDelete);
        }
    }

    private void saveSecondClassCollection(ArrayList collection) throws Exception {
        this.saveSecondClassCollection(collection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSecondClassCollection(ArrayList collection, boolean useCustomCollator) throws Exception {
        try {
            this.saveSecondClassCollectionInternal(collection, useCustomCollator);
        }
        finally {
            this.commit();
        }
    }

    private void saveSecondClassCollectionInternal(ArrayList collection, boolean useCustomCollator) throws Exception {
        Object elementToDelete = null;
        if (useCustomCollator) {
            Collections.sort(collection, new CollectionSorter());
        } else {
            Collections.sort(collection);
        }
        OpenJPAEntityManager pm1 = this.getPM();
        this.startTx((EntityManager)pm1);
        SCOTest test = new SCOTest();
        pm1.persist((Object)test);
        int testID = test.getId();
        Collection storedCollection = this.setGetCollection(test, (Collection)collection.clone(), true);
        TestSecondClassValues.assertNotNull((String)"retrieved storedCollection is null", (Object)storedCollection);
        TestSecondClassValues.assertEquals((String)("Pre-commit collections were not equal: " + this.newline + this.dump(collection) + this.newline + "!=" + this.newline + this.dump(storedCollection)), (int)collection.size(), (int)storedCollection.size());
        this.endTx((EntityManager)pm1);
        int deletionIndex = 0;
        OpenJPAEntityManager pm2 = this.getPM();
        while (collection.size() > 0) {
            ++deletionIndex;
            this.startTx((EntityManager)pm2);
            SCOTest retrievedObject = (SCOTest)pm2.find(SCOTest.class, (Object)testID);
            TestSecondClassValues.assertNotNull((String)"retrieved obj is null saveSecondClassCollectionInternal", (Object)retrievedObject);
            LinkedList identityCollection = new LinkedList(collection);
            TestSecondClassValues.assertNotNull((String)"identityCollection is null saveSecondClassCollectionInternal", identityCollection);
            Collection retrievedCollection = this.setGetCollection(retrievedObject, identityCollection, false);
            TestSecondClassValues.assertNotNull((String)"retrievedCollection is null saveSecondClassCollectionInternal", (Object)retrievedCollection);
            TestSecondClassValues.validateCollection(retrievedCollection);
            TestSecondClassValues.assertNotNull((Object)retrievedCollection);
            TestSecondClassValues.assertTrue((collection.size() != 0 ? 1 : 0) != 0);
            TestSecondClassValues.assertEquals((String)("Retreived collection does not match original after the " + deletionIndex + "th deletion (" + elementToDelete + "): " + this.newline + this.dump(collection) + this.newline + "!=" + this.newline + this.dump(retrievedCollection) + this.newline), (int)collection.size(), (int)retrievedCollection.size());
            Iterator ci = collection.iterator();
            Object co = collection.iterator().next();
            Iterator rci = retrievedCollection.iterator();
            Object rco = retrievedCollection.iterator().next();
            TestSecondClassValues.assertNotNull(co);
            TestSecondClassValues.assertNotNull(rco);
            TestSecondClassValues.assertEquals(co.getClass(), rco.getClass());
            ArrayList sortedRetreivedCollection = new ArrayList(retrievedCollection);
            if (useCustomCollator) {
                Collections.sort(sortedRetreivedCollection, new CollectionSorter());
            } else {
                Collections.sort(sortedRetreivedCollection);
            }
            Iterator i = collection.iterator();
            Iterator j = sortedRetreivedCollection.iterator();
            while (i.hasNext() && j.hasNext()) {
                this.assertClassAndValueEquals(i.next(), j.next());
            }
            elementToDelete = collection.iterator().next();
            if (!collection.remove(elementToDelete)) {
                TestSecondClassValues.fail((String)("Could not delete element (<" + elementToDelete.getClass().getName() + ">" + elementToDelete + ") " + "from " + this.dump(collection)));
            }
            if (!retrievedCollection.remove(elementToDelete)) {
                TestSecondClassValues.fail((String)("Could not delete element (" + elementToDelete + ") " + "from " + this.dump(retrievedCollection)));
            }
            this.endTx((EntityManager)pm2);
        }
    }

    private void assertClassAndValueEquals(Object o1, Object o2) {
        TestSecondClassValues.assertTrue((String)"First object was null", (o1 != null ? 1 : 0) != 0);
        TestSecondClassValues.assertTrue((String)"Second object was null", (o2 != null ? 1 : 0) != 0);
        TestSecondClassValues.assertTrue((String)("Types did not match (class1=" + o1.getClass().getName() + ", class2=" + o2.getClass().getName() + ")"), (boolean)o1.getClass().isAssignableFrom(o2.getClass()));
        TestSecondClassValues.assertEquals((String)("Object did not match (class1=" + o1.getClass().getName() + ", class2=" + o2.getClass().getName() + ")"), (Object)o1, (Object)o2);
    }

    private String dump(Collection coll) {
        LinkedList list = new LinkedList(coll);
        try {
            Collections.sort(list);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer().append("[").append("(size=").append(list.size()).append(")");
        Iterator it = list.iterator();
        if (it.hasNext()) {
            buf.append("<class=" + it.next().getClass().getName() + ">");
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            buf.append(i.next()).append(i.hasNext() ? "," : "");
        }
        return buf.append("]").toString();
    }

    private String dumpDates(Collection coll) {
        StringBuffer buf = new StringBuffer();
        Iterator i = coll.iterator();
        while (i.hasNext()) {
            buf.append(((Date)i.next()).getTime()).append(i.hasNext() ? "," : "");
        }
        return buf.toString();
    }

    private Map setGetMap(SCOTest test, HashMap map, boolean doSet) {
        if (map == null) {
            return null;
        }
        Object key = map.keySet().iterator().next();
        Object val = map.get(key);
        if (key instanceof Date && val instanceof String) {
            if (doSet) {
                test.setDateStrMap(map);
            }
            return test.getDateStrMap();
        }
        if (key instanceof Character && val instanceof Boolean) {
            if (doSet) {
                test.setCharBooleanMap(map);
            }
            return test.getCharBooleanMap();
        }
        if (key instanceof Double && val instanceof Character) {
            if (doSet) {
                test.setDoubleCharMap(map);
            }
            return test.getDoubleCharMap();
        }
        if (key instanceof Byte && val instanceof Double) {
            if (doSet) {
                test.setByteDoubleMap(map);
            }
            return test.getByteDoubleMap();
        }
        if (key instanceof Float && val instanceof Byte) {
            if (doSet) {
                test.setFloatByteMap(map);
            }
            return test.getFloatByteMap();
        }
        if (key instanceof Long && val instanceof Float) {
            if (doSet) {
                test.setLongFloatMap(map);
            }
            return test.getLongFloatMap();
        }
        if (key instanceof Integer && val instanceof Long) {
            if (doSet) {
                test.setIntLongMap(map);
            }
            return test.getIntLongMap();
        }
        if (key instanceof String && val instanceof Integer) {
            if (doSet) {
                test.setStrIntMap(map);
            }
            return test.getStrIntMap();
        }
        if (key instanceof BigDecimal && val instanceof BigInteger) {
            if (doSet) {
                test.setBigDecimalBigIntegerMap(map);
            }
            return test.getBigDecimalBigIntegerMap();
        }
        TestSecondClassValues.fail((String)"Unknown map type");
        return null;
    }

    private Collection setGetCollection(SCOTest test, Collection collection, boolean doSet) {
        if (collection == null) {
            return null;
        }
        Object first = collection.iterator().next();
        if (first instanceof BigInteger) {
            if (doSet) {
                test.setCBigInteger(collection);
            }
            return test.getCBigInteger();
        }
        if (first instanceof BigDecimal) {
            if (doSet) {
                test.setCBigDecimal(collection);
            }
            return test.getCBigDecimal();
        }
        if (first instanceof Date) {
            if (doSet) {
                test.setCDate(collection);
            }
            return test.getCDate();
        }
        if (first instanceof Character) {
            if (doSet) {
                test.setCCharacter(collection);
            }
            return test.getCCharacter();
        }
        if (first instanceof Double) {
            if (doSet) {
                test.setCDouble(collection);
            }
            return test.getCDouble();
        }
        if (first instanceof Byte) {
            if (doSet) {
                test.setCByte(collection);
            }
            return test.getCByte();
        }
        if (first instanceof Float) {
            if (doSet) {
                test.setCFloat(collection);
            }
            return test.getCFloat();
        }
        if (first instanceof Long) {
            if (doSet) {
                test.setCLong(collection);
            }
            return test.getCLong();
        }
        if (first instanceof Integer) {
            if (doSet) {
                test.setCInteger(collection);
            }
            return test.getCInteger();
        }
        if (first instanceof String) {
            if (doSet) {
                test.setCString(collection);
            }
            return test.getCString();
        }
        if (first instanceof Short) {
            if (doSet) {
                test.setCShort(collection);
            }
            return test.getCShort();
        }
        if (first instanceof Boolean) {
            if (doSet) {
                test.setCBoolean(collection);
            }
            return test.getCBoolean();
        }
        TestSecondClassValues.fail((String)"Unknown collection type");
        return null;
    }

    public static class CollectionSorter
    implements Comparator {
        private Collator collator = Collator.getInstance();

        public int compare(Object o1, Object o2) {
            if (o1 != null && !(o1 instanceof Boolean)) {
                return this.collator.compare(o1, o2);
            }
            return this.collator.compare(o1.toString(), o2.toString());
        }
    }
}

