/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.math.BigInteger;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.RestoreStateType;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.FetchGroupTestObject;

public class TestRestoreValues
extends BaseKernelTest {
    private Object _oid = null;

    public TestRestoreValues(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(FetchGroupTestObject.class);
        FetchGroupTestObject pc = new FetchGroupTestObject();
        pc.setA(1);
        pc.setB("2");
        pc.setC(new BigInteger("100"));
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        this._oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
    }

    public OpenJPAEntityManager getPM() {
        OpenJPAEntityManager pm = super.getPM();
        pm.setOptimistic(true);
        pm.setRestoreState(RestoreStateType.ALL);
        pm.setRetainState(true);
        return pm;
    }

    public void testUnloadedFieldDirtiedBeforeLoadedField() {
        OpenJPAEntityManager pm = this.getPM();
        FetchGroupTestObject pc = (FetchGroupTestObject)pm.find(FetchGroupTestObject.class, this._oid);
        TestRestoreValues.assertNotNull((String)"fetch object is null", (Object)pc);
        this.startTx((EntityManager)pm);
        pc.setB("3");
        pc.setA(2);
        this.rollbackTx((EntityManager)pm);
        TestRestoreValues.assertEquals((int)1, (int)pc.getA());
        TestRestoreValues.assertEquals((String)"2", (String)pc.getB());
        TestRestoreValues.assertEquals((Object)new BigInteger("100"), (Object)pc.getC());
        this.endEm((EntityManager)pm);
    }

    public void testUnloadedFieldDirtiedAfterLoadedField() {
        OpenJPAEntityManager pm = this.getPM();
        FetchGroupTestObject pc = (FetchGroupTestObject)pm.find(FetchGroupTestObject.class, this._oid);
        this.startTx((EntityManager)pm);
        pc.setA(2);
        pc.setB("3");
        this.rollbackTx((EntityManager)pm);
        TestRestoreValues.assertEquals((int)1, (int)pc.getA());
        TestRestoreValues.assertEquals((String)"2", (String)pc.getB());
        TestRestoreValues.assertEquals((Object)new BigInteger("100"), (Object)pc.getC());
        this.endEm((EntityManager)pm);
    }

    public void testLoadedFieldDirtiedAfterLoadedField() {
        OpenJPAEntityManager pm = this.getPM();
        FetchGroupTestObject pc = (FetchGroupTestObject)pm.find(FetchGroupTestObject.class, this._oid);
        this.startTx((EntityManager)pm);
        pc.setA(2);
        pc.getB();
        pc.setB("3");
        this.rollbackTx((EntityManager)pm);
        TestRestoreValues.assertEquals((int)1, (int)pc.getA());
        TestRestoreValues.assertEquals((String)"2", (String)pc.getB());
        TestRestoreValues.assertEquals((Object)new BigInteger("100"), (Object)pc.getC());
        this.endEm((EntityManager)pm);
    }

    public void testNewInstanceUnmodifiedInTransaction() {
        FetchGroupTestObject pc = new FetchGroupTestObject();
        pc.setA(2);
        pc.setB("3");
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.rollbackTx((EntityManager)pm);
        TestRestoreValues.assertEquals((int)2, (int)pc.getA());
        TestRestoreValues.assertEquals((String)"3", (String)pc.getB());
        this.endEm((EntityManager)pm);
    }
}

