/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.jdbc.FetchMode;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest3;
import org.apache.openjpa.util.UserException;

public class TestPessimisticLocking
extends BaseKernelTest {
    private Object _id = null;
    private int _bugCount = 0;
    private OpenJPAEntityManagerFactory _factory = null;

    public TestPessimisticLocking(String name) {
        super(name);
    }

    public TestPessimisticLocking() {
    }

    protected boolean skipTest() {
        if (this.getCurrentPlatform() == AbstractTestCase.Platform.POINTBASE) {
            return true;
        }
        if (this.getConfiguration() instanceof JDBCConfiguration) {
            JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
            return !conf.getDBDictionaryInstance().supportsSelectForUpdate;
        }
        return false;
    }

    protected OpenJPAEntityManager getLockingPM() {
        OpenJPAEntityManager pm = this._factory.createEntityManager();
        ((JDBCFetchPlan)pm.getFetchPlan()).setSubclassFetchMode(FetchMode.NONE);
        return pm;
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, RuntimeTest2.class, RuntimeTest3.class);
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.LockManager", "pessimistic");
        this._factory = this.getEmf(propsMap);
        OpenJPAEntityManager pm = this.getLockingPM();
        this.startTx((EntityManager)pm);
        RuntimeTest1 a = new RuntimeTest1("name", 0);
        pm.persist((Object)a);
        this._id = pm.getObjectId((Object)a);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void tearDown() {
        try {
            if (this._factory != null) {
                this._factory.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPessimisticLocking() throws Throwable {
        this.pessimisticLockingTest(false);
    }

    public void testPessimisticLockingInternal() throws Throwable {
        this.pessimisticLockingTest(true);
    }

    public void pessimisticLockingTest(boolean useReentrantLock) throws Throwable {
        long timeout = System.currentTimeMillis() + 300000L;
        ReentrantLock lock = null;
        if (useReentrantLock) {
            lock = new ReentrantLock();
        }
        TestThread t1 = new TestThread(lock);
        TestThread t2 = new TestThread(lock);
        t1.start();
        t2.start();
        this.getLog().trace((Object)"started thread");
        while ((t1.isAlive() || t2.isAlive()) && System.currentTimeMillis() < timeout) {
            Thread.sleep(1000L);
            this.getLog().trace((Object)("thread waiting for completion (" + (timeout - System.currentTimeMillis()) + " ms left)"));
        }
        this.getLog().trace((Object)"checking if thread is alive");
        System.out.flush();
        if (t1.isAlive() || t2.isAlive()) {
            this.getLog().trace((Object)"thread is still alive");
            System.out.flush();
            try {
                t1.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                t2.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new Exception("Thread did not complete after timeout (" + timeout + "): possible deadlock");
        }
        this.getLog().trace((Object)"checking exception for t1");
        if (t1.exception != null) {
            throw t1.exception;
        }
        this.getLog().trace((Object)"checking exception for t2");
        if (t2.exception != null) {
            throw t2.exception;
        }
        this.getLog().trace((Object)"verifying pessimistic locking worked...");
        OpenJPAEntityManager pm = this.getLockingPM();
        RuntimeTest1 a = (RuntimeTest1)pm.find(RuntimeTest1.class, this._id);
        TestPessimisticLocking.assertEquals((int)(20 - this._bugCount), (int)a.getIntField1());
        this.getLog().trace((Object)"closing pm");
        this.endEm((EntityManager)pm);
        this.getLog().trace((Object)"done");
    }

    private class TestThread
    extends Thread {
        private OpenJPAEntityManager _pm;
        public Exception exception;
        private final ReentrantLock _lock;

        public TestThread(ReentrantLock lock) {
            this._pm = TestPessimisticLocking.this.getLockingPM();
            this.exception = null;
            this._lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            TestPessimisticLocking.this.getLog().trace((Object)(Thread.currentThread().getName() + ": starting update thread"));
            try {
                for (int i = 0; i < 10; ++i) {
                    if (this._lock != null) {
                        this._lock.lock();
                    }
                    try {
                        this._pm.setOptimistic(false);
                        TestPessimisticLocking.this.startTx((EntityManager)this._pm);
                        RuntimeTest1 a = (RuntimeTest1)this._pm.find(RuntimeTest1.class, TestPessimisticLocking.this._id);
                        TestPessimisticLocking.this.getLog().trace((Object)(Thread.currentThread().getName() + ": obtained and locked: " + a));
                        TestThread.yield();
                        super.wait(50L);
                        TestPessimisticLocking.this.getLog().trace((Object)(Thread.currentThread().getName() + ": updating age from " + a.getIntField1()));
                        a.setIntField1(a.getIntField1() + 1);
                        TestPessimisticLocking.this.getLog().trace((Object)(Thread.currentThread().getName() + ": committed update"));
                        try {
                            this._pm.flush();
                            TestPessimisticLocking.this.endTx((EntityManager)this._pm);
                        }
                        catch (Exception ex) {
                            throw new UserException("Optimistic lock probably failed after " + i + " iterations (" + Thread.currentThread().getName() + ")", (Throwable)ex);
                        }
                        TestThread.yield();
                        continue;
                    }
                    finally {
                        if (this._lock != null) {
                            this._lock.unlock();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

