/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;

public class TestNTW
extends BaseKernelTest {
    private OpenJPAEntityManagerFactory factory;

    public TestNTW() {
    }

    public TestNTW(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.deleteAll(RuntimeTest1.class);
        OpenJPAEntityManager em = this.getPM();
        this.startTx((EntityManager)em);
        em.persist((Object)new RuntimeTest1("ntw0", 0));
        em.persist((Object)new RuntimeTest1("ntw1", 1));
        em.persist((Object)new RuntimeTest1("ntw2", 2));
        em.persist((Object)new RuntimeTest1("ntw3", 3));
        em.persist((Object)new RuntimeTest1("ntw4", 4));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.getPM();
        this.startTx((EntityManager)em);
    }

    public void testNonTransactionalWrite() throws Exception {
        OpenJPAEntityManagerFactory factory = this.broker();
        OpenJPAEntityManager em = factory.createEntityManager();
        OpenJPAQuery q = em.createQuery("SELECT o FROM RuntimeTest1 o ORDER BY o.stringField ASC");
        q.setSubclasses(false);
        List c = q.getResultList();
        for (RuntimeTest1 o : c) {
            o.setStringField(o.getStringField() + " modified");
        }
        this.startTx((EntityManager)em);
        this.endTx((EntityManager)em);
        q = em.createQuery("SELECT o FROM RuntimeTest1 o ORDER BY o.stringField ASC");
        q.setSubclasses(false);
        List results = q.getResultList();
        TestNTW.assertEquals((int)5, (int)results.size());
        this.endEm((EntityManager)em);
    }

    private OpenJPAEntityManagerFactory broker() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("OpenJPA.Optimistic", "true");
        map.put("OpenJPA.NontransactionalRead", "true");
        map.put("OpenJPA.NontransactionalWrite", "true");
        if (this.factory == null) {
            this.factory = OpenJPAPersistence.createEntityManagerFactory((String)"TestConv", null, map);
        }
        return this.factory;
    }
}

