/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;

public class TestMultiThreaded
extends BaseKernelTest {
    static int serial = 5;
    static int threads = 5;
    static int iterations = 5;
    private OpenJPAEntityManager pm;
    private Object id;
    private String name;

    public TestMultiThreaded() {
    }

    public TestMultiThreaded(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        OpenJPAEntityManager pm2 = this.getPM();
        this.startTx((EntityManager)pm2);
        this.name = "testMultiThreaded" + Math.random();
        RuntimeTest1 a = new RuntimeTest1(this.name, (int)(Math.random() * 2.147483647E9));
        pm2.persist((Object)a);
        this.id = pm2.getObjectId((Object)a);
        this.endTx((EntityManager)pm2);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.Multithreaded", "true");
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        this.pm = pmf.createEntityManager();
        this.startTx((EntityManager)this.pm);
    }

    public void tearDown() throws Exception {
        try {
            this.rollbackTx((EntityManager)this.pm);
            this.endEm((EntityManager)this.pm);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testgetTransaction() {
        this.mttest(serial, threads, iterations);
        this.pm.getTransaction();
    }

    public void testGetObjectById() {
        this.mttest(serial, threads, iterations);
        TestMultiThreaded.assertNotNull((Object)this.pm.find(RuntimeTest1.class, this.id));
    }

    public void testQueryExecution() {
        this.mttest(serial, threads, iterations);
        OpenJPAQuery q = this.pm.createQuery("select o from RuntimeTest1 o where o.stringField = '" + this.name + "'");
        TestMultiThreaded.assertEquals((int)1, (int)q.getResultList().size());
    }

    public void testDeletePersistent() {
        this.mttest(serial, threads, iterations);
        this.pm.removeAll((Collection)this.pm.createQuery("select o from RuntimeTest1 o where o.stringField = '" + this.name + "'").getResultList());
    }

    public void testRefreshAll() {
        this.mttest(serial, threads, iterations);
        this.pm.refreshAll();
    }

    public void testEvictAll() {
        this.mttest(serial, threads, iterations);
        this.pm.evictAll();
    }

    public void testIterateExtent() throws Throwable {
        if (this.timeout(120000L)) {
            return;
        }
        this.mttest(serial, threads, iterations);
        TestMultiThreaded.assertTrue((String)"Transaction should have been active", (boolean)this.pm.getTransaction().isActive());
        for (int i = 0; i < 3; ++i) {
            this.pm.persist((Object)new RuntimeTest1("testIterateExtent" + Math.random(), (int)(Math.random() * 2.147483647E9)));
        }
        TestMultiThreaded.assertTrue((String)"Transaction should have been active", (boolean)this.pm.getTransaction().isActive());
        Iterator i = this.pm.createExtent(RuntimeTest1.class, true).iterator();
        while (i.hasNext()) {
            i.next();
        }
        TestMultiThreaded.assertTrue((String)"Transaction should have been active", (boolean)this.pm.getTransaction().isActive());
    }
}

