/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.kernel.common.apps.State;
import org.apache.openjpa.persistence.kernel.common.apps.Transition;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestIndirectRecursion
extends SingleEMFTestCase {
    static byte[][] transitions = new byte[][]{{0, 1, 0, 0, 0}, {1, 0, 1, 1, 0}, {1, 1, 0, 1, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}};

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, State.class, Transition.class);
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof OracleDictionary) {
            ((OracleDictionary)dict).useTriggersForAutoAssign = true;
        }
    }

    public void testFetch() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        int N = transitions.length;
        State[] states = new State[N];
        for (i = 1; i <= N; ++i) {
            State s = new State();
            s.setName("s" + i);
            em.persist((Object)s);
            states[i - 1] = s;
        }
        for (i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                if (transitions[i][j] != 1) continue;
                this.newTransition(states[i], states[j]);
            }
        }
        em.getTransaction().commit();
        em.clear();
        Query query = em.createQuery("select s from State s where s.name=:name");
        FetchPlan fetch = OpenJPAPersistence.cast((Query)query).getFetchPlan();
        fetch.setMaxFetchDepth(15);
        fetch.addField(State.class, "incomingTransitions");
        fetch.addField(State.class, "outgoingTransitions");
        fetch.addField(Transition.class, "toState");
        fetch.addField(Transition.class, "fromState");
        State qs1 = (State)query.setParameter("name", (Object)"s1").getSingleResult();
        em.close();
        byte[][] actualTransitionMatrix = new byte[5][5];
        this.fillTransitionMatrix(actualTransitionMatrix, new HashSet<State>(), qs1);
        this.assertMatrixEqual(transitions, actualTransitionMatrix);
    }

    void assertMatrixEqual(byte[][] expected, byte[][] actual) {
        int N = transitions.length;
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                TestIndirectRecursion.assertEquals((String)("Transition(s" + (i + 1) + ", s" + (j + 1) + ") does not match"), (byte)expected[i][j], (byte)actual[i][j]);
            }
        }
    }

    void fillTransitionMatrix(byte[][] matrix, Set<State> visited, State s) {
        if (visited.contains(s)) {
            return;
        }
        List<Transition> outgoings = s.getOutgoingTransitions();
        if (outgoings != null) {
            for (Transition t : outgoings) {
                this.fillTransitionMatrix(matrix, t);
            }
        }
        visited.add(s);
        if (outgoings != null) {
            for (Transition t : outgoings) {
                this.fillTransitionMatrix(matrix, visited, t.getToState());
            }
        }
    }

    void fillTransitionMatrix(byte[][] matrix, Transition t) {
        matrix[this.getIndex((State)t.getFromState())][this.getIndex((State)t.getToState())] = 1;
    }

    int getIndex(State s) {
        return Integer.parseInt(s.getName().substring(1)) - 1;
    }

    Transition newTransition(State from, State to) {
        Transition t = new Transition();
        t.setFromState(from);
        t.setToState(to);
        t.setName(from.getName() + "->" + to.getName());
        from.addOutgoingTransitions(t);
        to.addIncomingTransitions(t);
        return t;
    }

    State findOutgoingState(String name, State root) {
        List<Transition> transitions = root.getOutgoingTransitions();
        for (Transition t : transitions) {
            if (!t.getToState().getName().equals(name)) continue;
            return t.getToState();
        }
        return null;
    }

    State findIncomingState(String name, State root) {
        List<Transition> transitions = root.getIncomingTransitions();
        for (Transition t : transitions) {
            if (!t.getFromState().getName().equals(name)) continue;
            return t.getFromState();
        }
        return null;
    }

    void assertIncomingStates(State origin, State ... expected) {
        TestIndirectRecursion.assertNotNull((Object)origin);
        for (State e : expected) {
            TestIndirectRecursion.assertNotNull((String)(e + " in not an incoimng states of " + origin), (Object)this.findIncomingState(e.getName(), origin));
        }
    }

    void assertOutgoingStates(State origin, State ... expected) {
        TestIndirectRecursion.assertNotNull((Object)origin);
        for (State e : expected) {
            TestIndirectRecursion.assertNotNull((String)(e + " in not an incoimng states of " + origin), (Object)this.findOutgoingState(e.getName(), origin));
        }
    }
}

