/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest3;

public class TestIncrementalFlushesDeletes
extends BaseKernelTest {
    private OpenJPAEntityManager pm;
    private Object oid;
    private RuntimeTest1 a;

    public TestIncrementalFlushesDeletes(String str) {
        super(str);
    }

    public TestIncrementalFlushesDeletes() {
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, RuntimeTest2.class, RuntimeTest3.class);
        this.pm = this.getPM(true, false);
        this.startTx((EntityManager)this.pm);
        this.a = new RuntimeTest1("foo", 10);
        this.pm.persist((Object)this.a);
        this.oid = this.pm.getObjectId((Object)this.a);
    }

    public void tearDown() throws Exception {
        this.endTx((EntityManager)this.pm);
        OpenJPAEntityManager newPm = this.getPM();
        try {
            Object o = newPm.find(RuntimeTest1.class, this.oid);
            if (o != null) {
                TestIncrementalFlushesDeletes.fail((String)"should not be able to load deleted object");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.endEm((EntityManager)newPm);
        this.endEm((EntityManager)this.pm);
        super.tearDown();
    }

    private void assertState(PCState state, boolean flushed) {
        OpenJPAStateManager sm = this.getStateManager(this.a, (EntityManager)this.pm);
        TestIncrementalFlushesDeletes.assertNotNull((Object)sm);
        TestIncrementalFlushesDeletes.assertEquals((boolean)flushed, (boolean)sm.isFlushed());
        TestIncrementalFlushesDeletes.assertEquals((Object)state, (Object)sm.getPCState());
    }

    public void testNewDeleted() {
        this.pm.remove((Object)this.a);
        this.assertState(PCState.PNEWDELETED, false);
    }

    public void testNewDeletedFlushed() {
        this.pm.remove((Object)this.a);
        this.assertState(PCState.PNEWDELETED, false);
        this.pm.flush();
        this.assertState(PCState.PNEWDELETED, true);
    }

    public void testNewFlushedDeleted() {
        this.pm.flush();
        this.assertState(PCState.PNEW, true);
        this.pm.remove((Object)this.a);
        this.assertState(PCState.PNEWFLUSHEDDELETED, true);
    }

    public void testNewFlushedDeletedFlushed() {
        this.pm.flush();
        this.assertState(PCState.PNEW, true);
        this.pm.remove((Object)this.a);
        this.assertState(PCState.PNEWFLUSHEDDELETED, true);
        this.pm.flush();
        this.assertState(PCState.PNEWFLUSHEDDELETEDFLUSHED, true);
    }
}

