/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.event.AbstractTransactionListener;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.ModInstanceCallbackTests;
import org.apache.openjpa.persistence.kernel.common.apps.ModRuntimeTest1;

public class TestIncrementalFlushes
extends BaseKernelTest {
    public TestIncrementalFlushes(String str) {
        super(str);
    }

    public TestIncrementalFlushes() {
    }

    public void setUp() {
        this.deleteAll(ModRuntimeTest1.class);
    }

    public void testBasicJdoPreStore() {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModInstanceCallbackTests a = new ModInstanceCallbackTests("foo", 10);
        pm.persist((Object)a);
        pm.flush();
        TestIncrementalFlushes.assertTrue((boolean)a.preStoreCalled);
        this.endTx((EntityManager)pm);
    }

    public void testNoFlush() {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModInstanceCallbackTests a = new ModInstanceCallbackTests("foo", 10);
        pm.persist((Object)a);
        this.endTx((EntityManager)pm);
        TestIncrementalFlushes.assertTrue((boolean)a.preStoreCalled);
    }

    public void testFlushNoChange() {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModInstanceCallbackTests a = new ModInstanceCallbackTests("foo", 10);
        pm.persist((Object)a);
        pm.flush();
        this.endTx((EntityManager)pm);
        TestIncrementalFlushes.assertTrue((boolean)a.preStoreCalled);
        TestIncrementalFlushes.assertEquals((int)10, (int)a.getIntField());
    }

    private void basicHelper(boolean update, boolean multi, boolean dfg, boolean nonDFG) {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModInstanceCallbackTests a = new ModInstanceCallbackTests("foo", 10);
        pm.persist((Object)a);
        if (update) {
            this.endTx((EntityManager)pm);
            Object oid = pm.getObjectId((Object)a);
            this.endEm((EntityManager)pm);
            pm = this.getPM(true, false);
            this.startTx((EntityManager)pm);
            a = (ModInstanceCallbackTests)pm.find(ModInstanceCallbackTests.class, oid);
        } else {
            pm.flush();
        }
        if (dfg) {
            a.setIntField(11);
        }
        if (nonDFG) {
            a.setNonDFGField(11);
        }
        if (multi) {
            pm.flush();
            if (dfg) {
                a.setIntField(12);
            }
            if (nonDFG) {
                a.setNonDFGField(12);
            }
        }
        this.endTx((EntityManager)pm);
        if (multi) {
            if (dfg) {
                TestIncrementalFlushes.assertEquals((String)"a.getIntField is not 12", (int)12, (int)a.getIntField());
            }
            if (nonDFG) {
                TestIncrementalFlushes.assertEquals((String)"a.getNonDFGField is not 12", (int)12, (int)a.getNonDFGField());
            }
        } else {
            if (dfg) {
                TestIncrementalFlushes.assertEquals((String)"a.getIntField is not 12", (int)11, (int)a.getIntField());
            }
            if (nonDFG) {
                TestIncrementalFlushes.assertEquals((String)"a.getNonDFGField is not 12", (int)11, (int)a.getNonDFGField());
            }
        }
    }

    public void testFlushStorePrimaryDFGChange() {
        this.basicHelper(false, false, true, false);
        this.basicHelper(false, true, true, false);
        this.basicHelper(true, false, true, false);
        this.basicHelper(true, true, true, false);
    }

    public void testFlushStorePrimaryNonDFGChange() {
        this.basicHelper(false, false, false, true);
        this.basicHelper(false, true, false, true);
        this.basicHelper(true, false, false, true);
        this.basicHelper(true, true, false, true);
    }

    public void testFlushStorePrimaryNonDFGAndDFGChange() {
        this.basicHelper(false, false, true, true);
        this.basicHelper(false, true, true, true);
        this.basicHelper(true, false, true, true);
        this.basicHelper(true, true, true, true);
    }

    public void testFlushStorePrimaryNoChanges() {
        this.basicHelper(false, false, false, false);
        this.basicHelper(false, true, false, false);
        this.basicHelper(true, false, false, false);
        this.basicHelper(true, true, false, false);
    }

    public void testJdoPreStoreWithModificationBeforeFlush() {
        this.tjpswmHelper(true);
    }

    public void testJdoPreStoreWithModificationAfterFlush() {
        this.tjpswmHelper(false);
    }

    private void tjpswmHelper(boolean before) {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModInstanceCallbackTests a = new ModInstanceCallbackTests("foo", 10);
        pm.persist((Object)a);
        if (before) {
            a.setStringField("bar");
            pm.flush();
        } else {
            pm.flush();
            a.setStringField("bar");
        }
        this.endTx((EntityManager)pm);
        TestIncrementalFlushes.assertTrue((String)"a.preStoreCalled is false", (boolean)a.preStoreCalled);
        TestIncrementalFlushes.assertNotNull((String)"a.getOneOne is null", (Object)a.getOneOne());
        TestIncrementalFlushes.assertTrue((String)"getOneOne().getstrngfld.equals(jdoPrestore) is false", (boolean)a.getOneOne().getStringField().equals("jdoPreStore"));
    }

    public void testOneToOneBefore() {
        this.totoHelper(true, true, false);
        this.totoHelper(true, false, false);
        this.totoHelper(true, true, true);
        this.totoHelper(true, false, true);
    }

    public void testOneToOneAfter() {
        this.totoHelper(false, true, false);
        this.totoHelper(false, false, false);
        this.totoHelper(false, true, true);
        this.totoHelper(false, false, true);
    }

    private void totoHelper(boolean before, boolean persist, boolean multi) {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModInstanceCallbackTests a = new ModInstanceCallbackTests("foo", 10);
        pm.persist((Object)a);
        ModRuntimeTest1 parent = new ModRuntimeTest1("baz", 11);
        if (!before) {
            pm.flush();
        }
        if (persist) {
            pm.persist((Object)parent);
        }
        a.setOneOne(parent);
        if (before) {
            pm.flush();
        }
        ModRuntimeTest1 oldParent = null;
        if (multi) {
            oldParent = parent;
            parent = new ModRuntimeTest1("newParent", 12);
            if (!before) {
                pm.flush();
            }
            if (persist) {
                pm.persist((Object)parent);
            }
            a.setOneOne(parent);
            if (before) {
                pm.flush();
            }
        }
        this.endTx((EntityManager)pm);
        TestIncrementalFlushes.assertTrue((String)"a.preStoreCalled is false", (boolean)a.preStoreCalled);
        TestIncrementalFlushes.assertNotNull((String)"a.getOneOne is null", (Object)a.getOneOne());
        if (!multi) {
            TestIncrementalFlushes.assertTrue((String)"a.getOneOne().getStringField().equals(baz) is false", (boolean)a.getOneOne().getStringField().equals("baz"));
        } else {
            TestIncrementalFlushes.assertTrue((String)"a.getOneOne().getStringField().equals(newParent) is false", (boolean)a.getOneOne().getStringField().equals("newParent"));
        }
    }

    private void assertState(Object o, PCState state, OpenJPAEntityManager pm) {
        TestIncrementalFlushes.assertEquals((Object)state, (Object)this.getStateManager(o, (EntityManager)pm).getPCState());
    }

    private void commitAndTestDelete(OpenJPAEntityManager pm, Object o) {
        Object oid = pm.getObjectId(o);
        this.endTx((EntityManager)pm);
        pm = this.getPM();
        try {
            pm.find(Object.class, oid);
            TestIncrementalFlushes.fail((String)"should not be able to load deleted object");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testDeleteNew() {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest1 a = new ModRuntimeTest1("foo", 10);
        pm.persist((Object)a);
        pm.remove((Object)a);
        this.assertState(a, PCState.PNEWDELETED, pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptimisticLockGivesCorrectError() {
        OpenJPAEntityManager pm1 = this.getPM(true, false);
        OpenJPAEntityManager pm2 = this.getPM(true, false);
        ModRuntimeTest1 a1 = new ModRuntimeTest1("foo", 10);
        this.startTx((EntityManager)pm1);
        pm1.persist((Object)a1);
        this.endTx((EntityManager)pm1);
        ModRuntimeTest1 a2 = (ModRuntimeTest1)pm2.find(ModRuntimeTest1.class, pm2.getObjectId((Object)a1));
        this.startTx((EntityManager)pm2);
        a2.setStringField("foobar");
        this.endTx((EntityManager)pm2);
        this.startTx((EntityManager)pm1);
        a1.setStringField("foobarbaz");
        try {
            this.endTx((EntityManager)pm1);
        }
        catch (Exception ole) {
        }
        finally {
            this.rollbackTx((EntityManager)pm1);
            pm1.close();
            pm2.close();
        }
    }

    public void XXXtestFlushesAreIsolated() {
        String name = "testFlushesAreIsolated";
        this.deleteAll(ModRuntimeTest1.class);
        OpenJPAEntityManager flushPM = this.getPM(true, false);
        this.startTx((EntityManager)flushPM);
        OpenJPAEntityManager readPM = this.getPM(true, false);
        this.startTx((EntityManager)readPM);
        this.assertSize(0, (Query)flushPM.createNativeQuery("stringField == 'testFlushesAreIsolated'", ModRuntimeTest1.class));
        this.assertSize(0, (Query)readPM.createNativeQuery("stringField == 'testFlushesAreIsolated'", ModRuntimeTest1.class));
        ModRuntimeTest1 a = new ModRuntimeTest1("testFlushesAreIsolated", TestIncrementalFlushes.randomInt());
        flushPM.persist((Object)a);
        this.assertSize(0, (Query)readPM.createNativeQuery("name == 'testFlushesAreIsolated'", ModRuntimeTest1.class));
        flushPM.flush();
        this.assertSize(0, (Query)readPM.createNativeQuery("name == 'testFlushesAreIsolated'", ModRuntimeTest1.class));
        flushPM.remove((Object)a);
        this.assertSize(0, (Query)flushPM.createNativeQuery("name == 'testFlushesAreIsolated'", ModRuntimeTest1.class));
        this.assertSize(0, (Query)readPM.createNativeQuery("name == 'testFlushesAreIsolated'", ModRuntimeTest1.class));
        this.endTx((EntityManager)flushPM);
        this.endEm((EntityManager)flushPM);
        this.endTx((EntityManager)readPM);
        this.endEm((EntityManager)readPM);
    }

    public void testEmptyFlush() {
        OpenJPAEntityManager pm = this.getPM();
        TListener listener = new TListener();
        ((OpenJPAEntityManagerSPI)pm).addTransactionListener((Object)listener);
        this.startTx((EntityManager)pm);
        ModRuntimeTest1 pc = new ModRuntimeTest1();
        pm.persist((Object)pc);
        pm.flush();
        TestIncrementalFlushes.assertEquals((int)1, (int)listener.flushes);
        TestIncrementalFlushes.assertEquals((int)0, (int)listener.commits);
        pm.flush();
        TestIncrementalFlushes.assertEquals((int)1, (int)listener.flushes);
        TestIncrementalFlushes.assertEquals((int)0, (int)listener.commits);
        pc.setIntField(3);
        pm.flush();
        TestIncrementalFlushes.assertEquals((int)2, (int)listener.flushes);
        TestIncrementalFlushes.assertEquals((int)0, (int)listener.commits);
        this.endTx((EntityManager)pm);
        TestIncrementalFlushes.assertEquals((int)2, (int)listener.flushes);
        TestIncrementalFlushes.assertEquals((int)1, (int)listener.commits);
        this.endEm((EntityManager)pm);
    }

    public void testEmptyRollback() {
        OpenJPAEntityManager pm = this.getPM();
        TListener listener = new TListener();
        ((OpenJPAEntityManagerSPI)pm).addTransactionListener((Object)listener);
        this.startTx((EntityManager)pm);
        pm.flush();
        this.rollbackTx((EntityManager)pm);
        TestIncrementalFlushes.assertEquals((int)0, (int)listener.flushes);
        TestIncrementalFlushes.assertEquals((int)0, (int)listener.commits);
        this.endEm((EntityManager)pm);
    }

    public void testEmptyCommit() {
        OpenJPAEntityManager pm = this.getPM();
        TListener listener = new TListener();
        ((OpenJPAEntityManagerSPI)pm).addTransactionListener((Object)listener);
        this.startTx((EntityManager)pm);
        this.endTx((EntityManager)pm);
        TestIncrementalFlushes.assertEquals((int)0, (int)listener.flushes);
        TestIncrementalFlushes.assertEquals((int)1, (int)listener.commits);
        this.endEm((EntityManager)pm);
    }

    private static class TListener
    extends AbstractTransactionListener {
        public int flushes = 0;
        public int commits = 0;

        private TListener() {
        }

        protected void eventOccurred(TransactionEvent event) {
            if (event.getType() == 1) {
                ++this.flushes;
            } else if (event.getType() == 3) {
                ++this.commits;
            }
        }
    }
}

