/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.PCAddress;
import org.apache.openjpa.persistence.kernel.common.apps.PCCompany;
import org.apache.openjpa.persistence.kernel.common.apps.PCCountry;
import org.apache.openjpa.persistence.kernel.common.apps.PCDepartment;
import org.apache.openjpa.persistence.kernel.common.apps.PCDirectory;
import org.apache.openjpa.persistence.kernel.common.apps.PCEmployee;
import org.apache.openjpa.persistence.kernel.common.apps.PCFile;
import org.apache.openjpa.persistence.kernel.common.apps.PCPerson;

public class TestFetchPlan
extends BaseKernelTest {
    static Object _rootDirId;
    static Object _rootCompanyId;
    static final int MAX_DEPTH = 5;
    static final int MAX_CHILD = 3;
    static final String quote = "\"";
    private static boolean firstTime;

    public TestFetchPlan() {
    }

    public TestFetchPlan(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        if (firstTime) {
            firstTime = false;
            this.clearTestData();
            this.createTestData();
        }
    }

    void createTestData() {
        PCDirectory rootDir;
        PCDirectory parent = rootDir = new PCDirectory(this.getDirectoryName(0));
        for (int i = 1; i <= 5; ++i) {
            PCDirectory dir = new PCDirectory(this.getDirectoryName(i));
            parent.add(dir);
            for (int j = 0; j < 3; ++j) {
                parent.add(this.getFileName(j));
            }
            parent = dir;
        }
        PCCountry country1 = new PCCountry("100", "Employee 1 Country");
        PCCountry country2 = new PCCountry("200", "Employee 2 Country");
        PCCountry ccountry = new PCCountry("300", "Company Country");
        PCCompany company = new PCCompany("Company");
        PCDepartment dept1 = new PCDepartment("Department1");
        PCDepartment dept2 = new PCDepartment("Department2");
        PCEmployee emp1 = new PCEmployee("Employee1");
        PCEmployee emp2 = new PCEmployee("Employee2");
        PCAddress addr1 = new PCAddress("Street1", "city1", country1);
        PCAddress addr2 = new PCAddress("Street2", "city2", country2);
        PCAddress caddr = new PCAddress("Street3", "city3", ccountry);
        dept1.addEmployee(emp1);
        dept2.addEmployee(emp2);
        company.addDepartment(dept1);
        company.addDepartment(dept2);
        company.setAddress(caddr);
        emp1.setAddress(addr1);
        emp2.setAddress(addr2);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)rootDir);
        pm.persist((Object)company);
        _rootDirId = rootDir.getId();
        TestFetchPlan.assertNotNull((Object)_rootDirId);
        _rootCompanyId = company.getId();
        TestFetchPlan.assertNotNull((Object)_rootCompanyId);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testZeroRecursionDepthSingleValuedField() {
        this.genericTestForSingleValuedRecursiveField("name", 4, 0);
    }

    public void testOneRecursionDepthSingleValuedField() {
        this.genericTestForSingleValuedRecursiveField("name+parent", 4, 1);
    }

    public void testTwoRecursionDepthSingleValuedField() {
        this.genericTestForSingleValuedRecursiveField("name+parent+grandparent", 4, 2);
    }

    public void testThreeRecursionDepthSingleValuedField() {
        this.genericTestForSingleValuedRecursiveField("name+parent+grandparent+greatgrandparent", 4, 3);
    }

    public void testInfiniteRecursionDepthSingleValuedField() {
        this.genericTestForSingleValuedRecursiveField("allparents", 4, -1);
    }

    public void genericTestForSingleValuedRecursiveField(String plan, int rd, int fd) {
        PCDirectory result = this.queryDirectoryWithPlan(plan, rd, fd);
        this.checkParents(result, rd, fd);
        Object children = PCDirectory.reflect(result, "_children");
        TestFetchPlan.assertNull((Object)children);
    }

    PCDirectory queryDirectoryWithPlan(String plan, int rd, int fd) {
        OpenJPAEntityManager pm = this.getPM();
        pm.getFetchPlan().addFetchGroup(plan);
        if (fd != 0) {
            pm.getFetchPlan().setMaxFetchDepth(fd);
        }
        String query = "SELECT o FROM PCDirectory o WHERE o._name = '" + this.getDirectoryName(rd) + "'";
        List fresult = pm.createQuery(query).getResultList();
        TestFetchPlan.assertEquals((int)1, (int)fresult.size());
        PCDirectory dir = (PCDirectory)fresult.get(0);
        return dir;
    }

    void checkParents(PCDirectory result, int D2, int L) {
        int i;
        TestFetchPlan.assertEquals((String)"ge", (Object)this.getDirectoryName(D2), (Object)PCDirectory.reflect(result, "_name"));
        PCDirectory[] parents = this.getParents(result, D2);
        int N = L == -1 ? D2 : L;
        for (i = 0; i < N; ++i) {
            TestFetchPlan.assertNotNull((String)(i + "-th parent at depth " + D2 + " is null"), (Object)parents[i]);
            TestFetchPlan.assertEquals((Object)this.getDirectoryName(D2 - i - 1), (Object)PCDirectory.reflect(parents[i], "_name"));
        }
        for (i = N; i < D2; ++i) {
            TestFetchPlan.assertNull((String)(i + "-th parent at depth " + D2 + " is not null " + parents[i]), (Object)parents[i]);
        }
    }

    PCDirectory[] getParents(PCDirectory dir, int depth) {
        PCDirectory[] result = new PCDirectory[depth];
        PCDirectory current = dir;
        for (int i = 0; i < depth; ++i) {
            result[i] = (PCDirectory)PCDirectory.reflect(current, "_parent");
            current = result[i];
        }
        return result;
    }

    void assertNullParent(PCDirectory[] parents, int L) {
        int i;
        for (i = 0; i < L; ++i) {
            TestFetchPlan.assertNotNull((Object)parents[i]);
        }
        for (i = L; i < parents.length; ++i) {
            TestFetchPlan.assertNull((Object)parents[i]);
        }
    }

    String getDirectoryName(int depth) {
        return "d" + depth;
    }

    String getFileName(int depth) {
        return "f" + depth;
    }

    String quoted(String s) {
        return quote + s + quote;
    }

    public void testRelationTraversal() {
        OpenJPAEntityManager pm = this.getPM();
        FetchPlan plan = pm.getFetchPlan();
        pm.getFetchPlan().setMaxFetchDepth(-1);
        plan.addFetchGroup("employee.department");
        plan.addFetchGroup("department.company");
        plan.addFetchGroup("company.address");
        plan.addFetchGroup("address.country");
        for (PCEmployee emp : pm.createExtent(PCEmployee.class, true)) {
            PCDepartment dept = (PCDepartment)PCEmployee.reflect(emp, "department");
            TestFetchPlan.assertNotNull((Object)dept);
            PCCompany company = (PCCompany)PCDepartment.reflect(dept, "company");
            TestFetchPlan.assertNotNull((Object)company);
            PCAddress addr = (PCAddress)PCCompany.reflect(company, "address");
            TestFetchPlan.assertNotNull((Object)addr);
            PCCountry country = (PCCountry)PCAddress.reflect(addr, "country");
            TestFetchPlan.assertNotNull((Object)country);
        }
    }

    public void testRelationTraversalTruncated() {
        OpenJPAEntityManager pm = this.getPM();
        FetchPlan plan = pm.getFetchPlan();
        pm.getFetchPlan().setMaxFetchDepth(-1);
        plan.addFetchGroup("employee.department");
        plan.addFetchGroup("department.company");
        plan.addFetchGroup("company.address");
        for (PCEmployee emp : pm.createExtent(PCEmployee.class, true)) {
            PCDepartment dept = (PCDepartment)PCEmployee.reflect(emp, "department");
            TestFetchPlan.assertNotNull((Object)dept);
            PCCompany company = (PCCompany)PCDepartment.reflect(dept, "company");
            TestFetchPlan.assertNotNull((Object)company);
            PCAddress addr = (PCAddress)PCCompany.reflect(company, "address");
            TestFetchPlan.assertNotNull((Object)addr);
            PCCountry country = (PCCountry)PCAddress.reflect(addr, "country");
            TestFetchPlan.assertNull((Object)country);
        }
    }

    public void testRelationTraversalWithCompanyAsRoot() {
        OpenJPAEntityManager pm = this.getPM();
        FetchPlan plan = pm.getFetchPlan();
        plan.setMaxFetchDepth(2);
        plan.addFetchGroup("company.departments");
        plan.addFetchGroup("company.address");
        plan.addFetchGroup("department.employees");
        plan.addFetchGroup("person.address");
        plan.addFetchGroup("address.country");
        PCCompany company = (PCCompany)pm.find(PCCompany.class, _rootCompanyId);
        Set departments = (Set)PCCompany.reflect(company, "departments");
        TestFetchPlan.assertNotNull((String)"department is null", (Object)departments);
        TestFetchPlan.assertEquals((String)"exp. depart size is not 2", (int)2, (int)departments.size());
        PCDepartment dept = (PCDepartment)departments.iterator().next();
        TestFetchPlan.assertNotNull((String)"dept is null", (Object)dept);
        Set employees = (Set)PCDepartment.reflect(dept, "employees");
        TestFetchPlan.assertNotNull((String)"employees is null", (Object)employees);
        TestFetchPlan.assertEquals((int)1, (int)employees.size());
        PCEmployee emp = (PCEmployee)employees.iterator().next();
        TestFetchPlan.assertNotNull((String)"emp is not null", (Object)emp);
        PCAddress eaddr = (PCAddress)PCPerson.reflect(emp, "address");
        PCAddress caddr = (PCAddress)PCCompany.reflect(company, "address");
        TestFetchPlan.assertNull((String)"eaddr is not null", (Object)eaddr);
        TestFetchPlan.assertNotNull((String)"caddr is null", (Object)caddr);
        PCCountry country = (PCCountry)PCAddress.reflect(caddr, "country");
        TestFetchPlan.assertNotNull((String)"country is null", (Object)country);
    }

    public void testDetachedRelationTraversalWithCompanyAsRoot() {
        OpenJPAEntityManager pm = this.getPM();
        FetchPlan plan = pm.getFetchPlan();
        pm.getFetchPlan().setMaxFetchDepth(2);
        plan.addFetchGroup("company.departments");
        plan.addFetchGroup("company.address");
        plan.addFetchGroup("department.employees");
        plan.addFetchGroup("person.address");
        plan.addFetchGroup("address.country");
        PCCompany company1 = (PCCompany)pm.find(PCCompany.class, _rootCompanyId);
        PCCompany company = (PCCompany)pm.detachCopy((Object)company1);
        TestFetchPlan.assertTrue((String)"company is equal company1", (company != company1 ? 1 : 0) != 0);
        Set departments = (Set)PCCompany.reflect(company, "departments");
        TestFetchPlan.assertNotNull((String)"department is null", (Object)departments);
        TestFetchPlan.assertEquals((String)"department size is not 2", (int)2, (int)departments.size());
        PCDepartment dept = (PCDepartment)departments.iterator().next();
        TestFetchPlan.assertNotNull((String)"dept is null", (Object)dept);
        Set employees = (Set)PCDepartment.reflect(dept, "employees");
        TestFetchPlan.assertNotNull((String)"employee is null", (Object)employees);
        TestFetchPlan.assertEquals((String)"employees size not 1", (int)1, (int)employees.size());
        PCEmployee emp = (PCEmployee)employees.iterator().next();
        TestFetchPlan.assertNotNull((String)"emp is null", (Object)emp);
        PCAddress eaddr = (PCAddress)PCPerson.reflect(emp, "address");
        PCAddress caddr = (PCAddress)PCCompany.reflect(company, "address");
        TestFetchPlan.assertNull((String)"eaddr is not null", (Object)eaddr);
        TestFetchPlan.assertNotNull((String)"caddr is null", (Object)caddr);
        PCCountry country = (PCCountry)PCAddress.reflect(caddr, "country");
        TestFetchPlan.assertNotNull((String)"country is null", (Object)country);
    }

    public void testDefaultFetchGroup() {
        OpenJPAEntityManager pm = this.getPM();
        String squery = "SELECT DISTINCT o FROM PCEmployee o WHERE o.name = 'Employee1'";
        OpenJPAQuery q = pm.createQuery(squery);
        PCEmployee person = (PCEmployee)q.getSingleResult();
        TestFetchPlan.assertEquals((String)"Exp. String is not employee1", (Object)"Employee1", (Object)PCPerson.reflect(person, "name"));
    }

    public void testDefaultFetchGroupExistsByDefault() {
        OpenJPAEntityManager pm = this.getPM();
        TestFetchPlan.assertTrue((String)"pm does not contain default fetchplan", (boolean)pm.getFetchPlan().getFetchGroups().contains("default"));
    }

    public void testDefaultFetchGroupCanBeRemoved() {
        OpenJPAEntityManager pm = this.getPM();
        TestFetchPlan.assertTrue((String)"does not contain default fetchplan", (boolean)pm.getFetchPlan().getFetchGroups().contains("default"));
        pm.getFetchPlan().removeFetchGroup("default");
        TestFetchPlan.assertFalse((String)"does contain default fetchplan", (boolean)pm.getFetchPlan().getFetchGroups().contains("default"));
        OpenJPAEntityManager pm2 = this.getPM();
        TestFetchPlan.assertTrue((String)"pm2 does not contain default fetchplan", (boolean)pm2.getFetchPlan().getFetchGroups().contains("default"));
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private void clearTestData() throws Exception {
        this.deleteAll(PCDirectory.class);
        this.deleteAll(PCFile.class);
        this.deleteAll(PCPerson.class);
        this.deleteAll(PCDepartment.class);
        this.deleteAll(PCCompany.class);
        this.deleteAll(PCAddress.class);
        this.deleteAll(PCCountry.class);
        this.deleteAll(PCEmployee.class);
    }

    static {
        firstTime = true;
    }
}

