/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;

public class TestExtents
extends BaseKernelTest {
    public TestExtents() {
    }

    public TestExtents(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, RuntimeTest2.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        RuntimeTest1 b = new RuntimeTest1("STRING", 10);
        RuntimeTest2 c = new RuntimeTest2("STRING2", 11);
        pm.persist((Object)b);
        pm.persist((Object)c);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testExtent1() {
        OpenJPAEntityManager pm = this.getPM();
        Extent ext = pm.createExtent(RuntimeTest1.class, false);
        TestExtents.assertEquals((Object)pm, (Object)ext.getEntityManager());
        TestExtents.assertEquals(RuntimeTest1.class, (Object)ext.getElementClass());
        TestExtents.assertTrue((!ext.hasSubclasses() ? 1 : 0) != 0);
    }

    public void testExtent2() {
        OpenJPAEntityManager pm = this.getPM();
        Extent ext = pm.createExtent(RuntimeTest1.class, false);
        boolean found = false;
        Iterator i = ext.iterator();
        while (i.hasNext()) {
            TestExtents.assertEquals(RuntimeTest1.class, i.next().getClass());
            found = true;
        }
        TestExtents.assertTrue((boolean)found);
    }

    public void testExtent3() {
        OpenJPAEntityManager pm = this.getPM();
        Extent ext = pm.createExtent(RuntimeTest1.class, true);
        boolean foundB = false;
        Iterator i = ext.iterator();
        while (i.hasNext()) {
            if (!i.next().getClass().equals(RuntimeTest2.class)) continue;
            foundB = true;
        }
        TestExtents.assertTrue((boolean)foundB);
    }

    public void testExtent4() {
        OpenJPAEntityManager pm = this.getPM();
        Extent ext = pm.createExtent(RuntimeTest1.class, true);
        LinkedList all = new LinkedList();
        Iterator i = ext.iterator();
        while (i.hasNext()) {
            all.add(i.next());
        }
        List aList = ext.list();
        TestExtents.assertEquals((int)all.size(), (int)aList.size());
        this.assertContainsSame(all, aList);
    }

    private void assertContainsSame(List l, Collection c) {
        int size = 0;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            ++size;
            iter.next();
        }
        TestExtents.assertEquals((int)l.size(), (int)size);
        iter = l.iterator();
        while (iter.hasNext()) {
            TestExtents.assertTrue((boolean)c.contains(iter.next()));
        }
    }
}

