/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestEJBTransactions
extends AbstractTestCase {
    public TestEJBTransactions(String name) {
        super(name, "kernelcactusapp");
    }

    public void setUp() {
    }

    public void testTxCannotBeCommittedTwiceInDiffThreads() throws Throwable {
        ArrayList list = new ArrayList();
        OpenJPAEntityManager em = this.currentEntityManager();
        EntityTransaction tx = em.getTransaction();
        if (tx.isActive()) {
            tx.rollback();
        }
        tx.begin();
        this.endTx((EntityManager)em);
        Thread thread = new Thread((EntityManager)em, list){
            final /* synthetic */ EntityManager val$em;
            final /* synthetic */ ArrayList val$list;
            {
                this.val$em = entityManager;
                this.val$list = arrayList;
            }

            public void run() {
                try {
                    TestEJBTransactions.this.endTx(this.val$em);
                    this.val$list.add(new Integer(0));
                }
                catch (Exception e) {
                    this.val$list.add(e);
                }
                catch (Throwable t) {
                    this.val$list.add(t);
                }
            }
        };
        thread.start();
        while (list.size() == 0) {
        }
        Object result = list.get(0);
        if (!(result instanceof Exception) && result instanceof Throwable) {
            throw (Throwable)result;
        }
        thread.join();
    }

    public void testTransactionsCannotBeCommittedTwice() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.rollbackTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        this.endTx((EntityManager)pm);
        try {
            this.endTx((EntityManager)pm);
        }
        catch (Exception e) {
            System.out.println("Exception should be thrown here...Transactions cannot be committed twice...");
        }
    }

    public void testTransactionsCannotBeRolledBackTwice() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        EntityTransaction t = pm.getTransaction();
        if (t.isActive()) {
            t.rollback();
        } else {
            t.begin();
            t.rollback();
        }
        try {
            t.rollback();
        }
        catch (Exception e) {
            System.out.println("Exception should be thrown here...Transactions cannot be rolled back twice...");
        }
    }
}

