/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Arrays;
import java.util.HashSet;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.kernel.common.apps.AllFieldsTypeTest;
import org.apache.openjpa.persistence.kernel.common.apps.ObjectCollectionHolder;

public class TestEJBObjectCollections
extends AbstractTestCase {
    public TestEJBObjectCollections(String name) {
        super(name, "kernelcactusapp");
    }

    public void testHashSet() {
        TestEJBObjectCollections.assertEquals((int)1, (int)this.add(new Object[]{"Foo"}, 1).getHashSet().size());
        TestEJBObjectCollections.assertEquals((int)1, (int)this.add(new Object[]{"Foo"}, 2).getHashSet().size());
        TestEJBObjectCollections.assertEquals((int)2, (int)this.add(new Object[]{"Foo", new AllFieldsTypeTest()}, 3).getHashSet().size());
    }

    public void setUp() {
        this.deleteAll(ObjectCollectionHolder.class);
        this.deleteAll(AllFieldsTypeTest.class);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public ObjectCollectionHolder add(Object[] objects, int id) {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ObjectCollectionHolder holder = new ObjectCollectionHolder();
        holder.setId(id);
        pm.persist((Object)holder);
        holder.setHashSet(new HashSet<Object>(Arrays.asList(objects)));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        return (ObjectCollectionHolder)pm.find(ObjectCollectionHolder.class, (Object)id);
    }
}

