/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestEJBNoPersistentFields
extends AbstractTestCase {
    private Nholder holder;

    public TestEJBNoPersistentFields(String test) {
        super(test, "kernelcactusapp");
    }

    public void setUp() throws Exception {
        this.deleteAll(Nholder.class);
    }

    public void testNoPersistentFields() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        this.holder = new Nholder();
        this.holder.setNpf(new NoPersistentFieldsPC());
        this.holder.setIdKey(1);
        em.persist((Object)this.holder);
        this.endTx((EntityManager)em);
        Nholder holder2 = (Nholder)em.find(Nholder.class, (Object)1);
        TestEJBNoPersistentFields.assertEquals((int)1, (int)holder2.getIdKey());
        TestEJBNoPersistentFields.assertNotNull((Object)holder2);
        TestEJBNoPersistentFields.assertNotNull((Object)holder2.getNpf());
        this.endEm((EntityManager)em);
    }

    @Entity
    @Table(name="npfp")
    public static class NoPersistentFieldsPC
    implements Serializable {
        public transient int blankInt;
        public transient String blankString;
    }

    @Entity
    @Table(name="nholder2")
    public static class Nholder
    implements Serializable {
        @Id
        private int idkey;
        @OneToOne(cascade={CascadeType.PERSIST, CascadeType.REMOVE})
        private NoPersistentFieldsPC npf;

        public Nholder() {
        }

        public Nholder(NoPersistentFieldsPC npf, int idkey) {
            this.npf = npf;
            this.idkey = idkey;
        }

        public void setNpf(NoPersistentFieldsPC npf) {
            this.npf = npf;
        }

        public NoPersistentFieldsPC getNpf() {
            return this.npf;
        }

        public int getIdKey() {
            return this.idkey;
        }

        public void setIdKey(int idkey) {
            this.idkey = idkey;
        }
    }
}

