/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestEJBLobs
extends AbstractTestCase {
    private EntityManager _pm = null;
    private Inner _inner = null;

    public TestEJBLobs(String name) {
        super(name, "kernelcactusapp");
    }

    public void setUp() throws Exception {
        super.setUp(Inner.class, Inner2.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        Inner inner = new Inner();
        inner.setString("string");
        inner.setClob("clobField");
        inner.setEBlob("eblob");
        Inner2 inner2 = new Inner2();
        inner2.string = "inner2";
        inner.setBlob(inner2);
        this._pm = this.currentEntityManager();
        this.startTx(this._pm);
        this._pm.persist((Object)inner);
        try {
            this.endTx(this._pm);
        }
        catch (Exception jdoe) {
            System.out.println("An exception was thrown while persisting the entity : \n" + this.getStackTrace(jdoe));
        }
        this.endEm(this._pm);
        this._pm = this.currentEntityManager();
        this._inner = (Inner)this._pm.find(Inner.class, (Object)"string");
    }

    public void testOtherFields() {
        TestEJBLobs.assertEquals((String)"string", (String)this._inner.getString());
    }

    public void testClob() {
        TestEJBLobs.assertEquals((String)"clobField", (String)this._inner.getClob());
    }

    public void testBlob() {
        TestEJBLobs.assertNotNull((Object)this._inner.getBlob());
        TestEJBLobs.assertEquals((String)"inner2", (String)this._inner.getBlob().string);
    }

    public void testSetNull() {
        this.startTx(this._pm);
        this._inner.setClob(null);
        this._inner.setBlob(null);
        this.endTx(this._pm);
        TestEJBLobs.assertEquals(null, (Object)this._inner.getBlob());
        TestEJBLobs.assertEquals(null, (String)this._inner.getClob());
    }

    public void testDelete() {
        this.deleteAll(Inner.class);
    }

    public void testUpdate() {
        this.startTx(this._pm);
        this._inner.setClob("newvalue");
        Inner2 inner2 = new Inner2();
        inner2.string = "newinner2";
        this._inner.setBlob(inner2);
        this.endTx(this._pm);
        TestEJBLobs.assertEquals((String)"newvalue", (String)this._inner.getClob());
        TestEJBLobs.assertEquals((String)"newinner2", (String)this._inner.getBlob().string);
    }

    @Entity
    @Table(name="Inner2")
    public static class Inner2
    implements Serializable {
        @Id
        public String string = null;

        public String getString() {
            return this.string;
        }

        public void setString(String string) {
            this.string = string;
        }
    }

    @Entity
    @Table(name="inntable")
    public static class Inner {
        @Id
        private String string = null;
        private String clobField = null;
        private Object eblob = null;
        @OneToOne(cascade={CascadeType.PERSIST, CascadeType.REMOVE})
        private Inner2 blobField = null;

        public String getString() {
            return this.string;
        }

        public void setString(String val) {
            this.string = val;
        }

        public String getClob() {
            return this.clobField;
        }

        public void setClob(String val) {
            this.clobField = val;
        }

        public String getEBlob() {
            return (String)this.eblob;
        }

        public void setEBlob(String val) {
            this.eblob = val;
        }

        public Inner2 getBlob() {
            return this.blobField;
        }

        public void setBlob(Inner2 val) {
            this.blobField = val;
        }
    }
}

