/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.ComplexEmbeddedPC;
import org.apache.openjpa.persistence.kernel.common.apps.EmbeddedOwnerPC;
import org.apache.openjpa.persistence.kernel.common.apps.EmbeddedPC;

public class TestEJBEmbedded
extends BaseKernelTest {
    private Object _oid1 = null;
    private Object _oid2 = null;
    EmbeddedOwnerPC.EmbKey id1;
    EmbeddedOwnerPC.EmbKey id2;

    public TestEJBEmbedded(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(EmbeddedOwnerPC.class);
        this.deleteAll(EmbeddedPC.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        EmbeddedOwnerPC pc1 = new EmbeddedOwnerPC(1, 2);
        pc1.setStringField("string1");
        EmbeddedPC embed1 = new EmbeddedPC();
        embed1.setStringField("embedString1");
        embed1.setIntField(1);
        pc1.setEmbedded(embed1);
        EmbeddedPC embed2 = new EmbeddedPC();
        embed2.setStringField("embedString2");
        embed2.setIntField(2);
        EmbeddedOwnerPC pc2 = new EmbeddedOwnerPC(3, 4);
        em.persist((Object)pc1);
        em.persist((Object)pc2);
        this.endTx((EntityManager)em);
        this.id1 = new EmbeddedOwnerPC.EmbKey("1:2");
        this.id2 = new EmbeddedOwnerPC.EmbKey();
        this.id2.id1 = 3;
        this.id2.id2 = 4;
        this.endEm((EntityManager)em);
    }

    public void testInsert() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        EmbeddedOwnerPC pc = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id1);
        EmbeddedOwnerPC pc2 = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id2);
        TestEJBEmbedded.assertNotNull((String)"pc is null in testInsert", (Object)pc);
        TestEJBEmbedded.assertNotNull((String)"p2 is null in testInsert", (Object)pc2);
        TestEJBEmbedded.assertEquals((String)"string1", (String)pc.getStringField());
        TestEJBEmbedded.assertNotNull((Object)pc.getEmbedded());
        TestEJBEmbedded.assertEquals((String)"embedString1", (String)pc.getEmbedded().getStringField());
        TestEJBEmbedded.assertEquals((int)1, (int)pc.getEmbedded().getIntField());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testDelete() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        EmbeddedOwnerPC pc = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id1);
        TestEJBEmbedded.assertNotNull((String)"pc is null in testDelete", (Object)pc);
        EmbeddedPC embed = pc.getEmbedded();
        pc.setEmbedded(null);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id1);
        TestEJBEmbedded.assertEquals((String)"the expt strng is not string1", (String)"string1", (String)pc.getStringField());
        TestEJBEmbedded.assertNull((String)"pc's embedded is null", (Object)pc.getEmbedded());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testUpdateRetain() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        EmbeddedOwnerPC pc = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id1);
        TestEJBEmbedded.assertNotNull((String)"pc is null testUpdateRetain", (Object)pc);
        pc.setStringField("string2");
        pc.getEmbedded().setStringField("embedString2");
        this.endTx((EntityManager)pm);
        TestEJBEmbedded.assertEquals((String)"string2", (String)pc.getStringField());
        TestEJBEmbedded.assertNotNull((Object)pc.getEmbedded());
        TestEJBEmbedded.assertEquals((String)"embedString2", (String)pc.getEmbedded().getStringField());
        TestEJBEmbedded.assertEquals((int)1, (int)pc.getEmbedded().getIntField());
        this.endEm((EntityManager)pm);
    }

    public void testReplace() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        EmbeddedOwnerPC pc = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id1);
        EmbeddedPC newEmbed = new EmbeddedPC();
        newEmbed.setStringField("embedString2");
        pc.setEmbedded(newEmbed);
        ComplexEmbeddedPC newComplexEmbed = new ComplexEmbeddedPC();
        newEmbed = new EmbeddedPC();
        newEmbed.setStringField("embedString3");
        newComplexEmbed.setStringField("complexEmbedString3");
        newComplexEmbed.setOwnerField(new EmbeddedOwnerPC(5, 6));
        pc.setComplexEmbedded(newComplexEmbed);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id1);
        TestEJBEmbedded.assertEquals((String)"string1", (String)pc.getStringField());
        TestEJBEmbedded.assertNotNull((Object)pc.getEmbedded());
        TestEJBEmbedded.assertEquals((String)"the exp strng is not embedString1", (String)"embedString1", (String)pc.getEmbedded().getStringField());
        TestEJBEmbedded.assertEquals((String)"intfield is not 1", (int)1, (int)pc.getEmbedded().getIntField());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testShare() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        EmbeddedOwnerPC pc1 = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id1);
        TestEJBEmbedded.assertNotNull((String)"pc1 is null in testshare", (Object)pc1);
        EmbeddedOwnerPC pc2 = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id2);
        TestEJBEmbedded.assertNotNull((String)"pc2 is null in testshare", (Object)pc2);
        EmbeddedPC embed1 = pc1.getEmbedded();
        pm.persist((Object)embed1);
        Integer oid = new Integer(1);
        this.endTx((EntityManager)pm);
        TestEJBEmbedded.assertEquals((String)"embedString1", (String)embed1.getStringField());
        TestEJBEmbedded.assertEquals((String)"embedString1", (String)pc1.getEmbedded().getStringField());
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc1 = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id1);
        TestEJBEmbedded.assertNotNull((String)"pc1 is null in testshare 2nd find", (Object)pc1);
        pc2 = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, (Object)this.id2);
        TestEJBEmbedded.assertNotNull((String)"pc2 is null in testshare 2nd find", (Object)pc2);
        embed1 = (EmbeddedPC)pm.find(EmbeddedPC.class, (Object)oid);
        if (embed1 != null) {
            TestEJBEmbedded.assertEquals((String)"embedString1", (String)embed1.getStringField());
            TestEJBEmbedded.assertEquals((String)"embedString1", (String)pc1.getEmbedded().getStringField());
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptimisticLocking2() {
        OpenJPAEntityManager pm1 = this.getPM(true, false);
        this.startTx((EntityManager)pm1);
        EmbeddedOwnerPC pc1 = (EmbeddedOwnerPC)pm1.find(EmbeddedOwnerPC.class, (Object)this.id1);
        TestEJBEmbedded.assertNotNull((String)"pc1 is null in testoptlock2", (Object)pc1);
        OpenJPAEntityManager pm2 = this.currentEntityManager();
        this.startTx((EntityManager)pm2);
        EmbeddedOwnerPC pc2 = (EmbeddedOwnerPC)pm1.find(EmbeddedOwnerPC.class, (Object)this.id1);
        TestEJBEmbedded.assertNotNull((String)"pc2 is null in testoptlock2", (Object)pc2);
        EmbeddedPC embed2 = pc2.getEmbedded();
        embed2.setStringField("xxxx");
        this.endTx((EntityManager)pm2);
        this.endEm((EntityManager)pm2);
        EmbeddedPC embed1 = pc1.getEmbedded();
        embed1.setStringField("yyyy");
        try {
            this.endTx((EntityManager)pm1);
            TestEJBEmbedded.fail((String)"Should have thrown an OL exception.");
        }
        catch (Exception ove) {
        }
        finally {
            this.endEm((EntityManager)pm1);
        }
    }
}

