/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.CalendarFields;

public class TestCalendarFields
extends BaseKernelTest {
    public TestCalendarFields(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(CalendarFields.class);
    }

    public void testFieldDefaultTimeZone() {
        CalendarFields cal = new CalendarFields();
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        cal.setSingapore(Calendar.getInstance(TimeZone.getTimeZone("America/New_York")));
        pm.persist((Object)cal);
        int id = cal.getId();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        cal = (CalendarFields)pm.find(CalendarFields.class, (Object)id);
        TestCalendarFields.assertEquals((Object)TimeZone.getTimeZone("Asia/Singapore"), (Object)cal.getSingapore().getTimeZone());
        this.endEm((EntityManager)pm);
    }

    public void testTimeZoneEquals() {
        CalendarFields c1 = new CalendarFields();
        CalendarFields c2 = new CalendarFields();
        this.assertTimeZonesEquals(c1, c2);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)c2);
        int id2 = c2.getId();
        this.assertTimeZonesEquals(c1, c2);
        this.endTx((EntityManager)pm);
        this.assertTimeZonesEquals(c1, c2);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        c2 = (CalendarFields)pm.find(CalendarFields.class, (Object)id2);
        this.assertTimeZonesEquals(c1, c2);
        this.assertTimeZonesEquals(c1, (CalendarFields)pm.detachCopy((Object)c2));
        this.endEm((EntityManager)pm);
    }

    public void testCalendarQuery() {
        long time = 1136660560572L;
        CalendarFields cal = new CalendarFields();
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        cal.getSingapore().setTime(new Date(time));
        pm.persist((Object)cal);
        int id = cal.getId();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        Date date = new Date(time + 100000L);
        Calendar cals = Calendar.getInstance();
        cals.setTime(date);
        String query = "SELECT o FROM CalendarFields o WHERE o.singapore < :cal";
        int size = pm.createQuery(query).setParameter("cal", (Object)cals).getResultList().size();
        TestCalendarFields.assertEquals((int)1, (int)size);
        this.endEm((EntityManager)pm);
    }

    private static Calendar newCalendar(Date date, String tz) {
        Calendar cal = Calendar.getInstance(tz == null ? TimeZone.getDefault() : TimeZone.getTimeZone(tz));
        cal.setTime(date);
        return cal;
    }

    public void testMutateCalendarDirties() {
        CalendarFields c1 = new CalendarFields();
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)c1);
        int id = c1.getId();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        c1 = (CalendarFields)pm.find(CalendarFields.class, (Object)id);
        this.startTx((EntityManager)pm);
        OpenJPAStateManager sm = this.getStateManager(c1, (EntityManager)pm);
        TestCalendarFields.assertFalse((boolean)sm.getDirty().get(sm.getMetaData().getField("gmt").getIndex()));
        TestCalendarFields.setTimeInMillis(c1.getGmt(), 12345L);
        TestCalendarFields.assertTrue((boolean)sm.getDirty().get(sm.getMetaData().getField("gmt").getIndex()));
        TestCalendarFields.assertFalse((boolean)sm.getDirty().get(sm.getMetaData().getField("newYork").getIndex()));
        c1.getNewYork().add(13, -1);
        TestCalendarFields.assertTrue((boolean)sm.getDirty().get(sm.getMetaData().getField("newYork").getIndex()));
        TestCalendarFields.assertFalse((boolean)sm.getDirty().get(sm.getMetaData().getField("berlin").getIndex()));
        c1.getBerlin().setTimeZone(TimeZone.getTimeZone("GMT"));
        TestCalendarFields.assertTrue((boolean)sm.getDirty().get(sm.getMetaData().getField("berlin").getIndex()));
        if (JavaVersions.VERSION >= 4) {
            TestCalendarFields.assertFalse((boolean)sm.getDirty().get(sm.getMetaData().getField("singapore").getIndex()));
            c1.getSingapore().set(1, 1998);
            TestCalendarFields.assertTrue((boolean)sm.getDirty().get(sm.getMetaData().getField("singapore").getIndex()));
        }
        TestCalendarFields.assertFalse((boolean)sm.getDirty().get(sm.getMetaData().getField("pacific").getIndex()));
        c1.getPacific().roll(1, 5);
        TestCalendarFields.assertTrue((boolean)sm.getDirty().get(sm.getMetaData().getField("pacific").getIndex()));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    private static void setTimeInMillis(Calendar cal, long millis) {
        try {
            cal.getClass().getMethod("setTimeInMillis", Long.TYPE).invoke((Object)cal, new Long(millis));
        }
        catch (Exception e) {
            cal.setTime(new Date(millis));
        }
    }

    private void assertTimeZonesEquals(CalendarFields c1, CalendarFields c2) {
        for (int i = 0; i < c1.getCalendars().size(); ++i) {
            Calendar cal1 = (Calendar)c1.getCalendars().get(i);
            Calendar cal2 = (Calendar)c2.getCalendars().get(i);
            if (cal1 == null || cal2 == null) continue;
            TestCalendarFields.assertEquals((String)cal1.getTimeZone().getID(), (String)cal2.getTimeZone().getID());
        }
    }
}

