/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.joins;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.apps.ArtCourse;
import org.apache.openjpa.persistence.common.apps.Course;
import org.apache.openjpa.persistence.common.apps.Department;
import org.apache.openjpa.persistence.common.apps.Student;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestEJBJoins
extends AbstractTestCase {
    public TestEJBJoins(String name) {
        super(name, "jpqlclausescactusapp");
    }

    public void setUp() {
        this.deleteAll(Course.class);
        this.deleteAll(Student.class);
        this.deleteAll(Department.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String name = "";
        ArrayList<Course> clist = new ArrayList<Course>();
        ArrayList<Department> dlist = new ArrayList<Department>();
        for (int i = 0; i < 5; ++i) {
            Course curr = new Course("Math " + i, i * 2, i);
            ArtCourse acurr = new ArtCourse(i + 20, "English" + 2 * i);
            Department durr = new Department("CompSci" + i, null, i + 2);
            clist.add(curr);
            clist.add(acurr);
            dlist.add(durr);
        }
        Student stud = new Student("Jonathan", clist, dlist);
        Student stud2 = new Student("Stam", null, dlist);
        Student stud3 = new Student("John", clist, null);
        Student stud4 = new Student("Bill", null, null);
        em.persist((Object)stud);
        em.persist((Object)stud2);
        em.persist((Object)stud3);
        em.persist((Object)stud4);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testInnerJoin() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT distinct o.name from Student o JOIN o.course d WHERE d.name='Math 4'";
        List ls = em.createQuery(query).getResultList();
        TestEJBJoins.assertNotNull((Object)ls);
        if (ls != null) {
            TestEJBJoins.assertEquals((int)2, (int)ls.size());
        }
        this.endEm((EntityManager)em);
    }

    public void testOuterJoin() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT distinct s.name FROM Student s LEFT JOIN s.department d";
        List ls = em.createQuery(query).getResultList();
        TestEJBJoins.assertNotNull((Object)ls);
        TestEJBJoins.assertEquals((int)4, (int)ls.size());
        this.endEm((EntityManager)em);
    }

    public void testFetchJoin1() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT s FROM Student s JOIN FETCH s.name";
        List ls = em.createQuery(query).getResultList();
        TestEJBJoins.assertNotNull((Object)ls);
        TestEJBJoins.assertEquals((int)4, (int)ls.size());
        this.endEm((EntityManager)em);
    }

    public void testFetchJoin2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT s FROM Student s JOIN FETCH s.name d";
        try {
            List ls = em.createQuery(query).getResultList();
            TestEJBJoins.fail((String)"Not permitted to specify an id variable for entities ref. by the right side of fetch join");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.endEm((EntityManager)em);
    }

    public void testLeftOuterJoin() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String ljoin = "SELECT DISTINCT s.name FROM Student s LEFT OUTER JOIN s.department d WHERE d.name = 'CompSci2'";
        List ls = em.createQuery(ljoin).getResultList();
        TestEJBJoins.assertNotNull((Object)ls);
        TestEJBJoins.assertEquals((int)2, (int)ls.size());
        TestEJBJoins.assertTrue((boolean)ls.contains("Jonathan"));
        TestEJBJoins.assertTrue((boolean)ls.contains("Stam"));
        this.endEm((EntityManager)em);
    }

    public void testInnerJoinFetch() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT s FROM Student s JOIN FETCH s.department";
        List ls = em.createQuery(query).getResultList();
        TestEJBJoins.assertNotNull((Object)ls);
        TestEJBJoins.assertEquals((int)2, (int)ls.size());
        em.close();
    }

    public void testLeftJoinFetch() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT s FROM Student s LEFT JOIN FETCH s.department";
        List ls = em.createQuery(query).getResultList();
        TestEJBJoins.assertNotNull((Object)ls);
        TestEJBJoins.assertEquals((int)4, (int)ls.size());
        em.close();
    }
}

